/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.kernel.validation.ValidationDescriptor;

public class ValidationRegistry {
    protected static final String MOKA_VALIDATION_EXTENSION_POINT_ID = "org.eclipse.papyrus.moka.kernel.validation";
    protected static final String VALIDATION_MAIN_CHILD = "validation";
    protected static final String VALIDATION_CATEGORY_CHILD = "category";
    protected static final String VALIDATION_CONTEXT_CHILD = "context";
    protected static final String VALIDATION_EXCLUDE_CONSTRAINT_CHILD = "excludeConstraint";
    protected static final String VALIDATION_EXCLUDE_CATEGORY_CHILD = "excludeCategory";
    protected static final String VALIDATION_CATEGORY_ID_ATTRIBUTE = "categoryID";
    protected static final String VALIDATION_CONTEXT_ID_ATTRIBUTE = "engineID";
    protected static final String VALIDATION_EXCLUDE_CONSTRAINT_ID_ATTRIBUTE = "constraintID";
    protected Map<String, Set<ValidationDescriptor>> registry = new HashMap<String, Set<ValidationDescriptor>>();
    private static ValidationRegistry INSTANCE;

    private ValidationRegistry() {
        this.loadValidations();
    }

    public static ValidationRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ValidationRegistry();
        }
        return INSTANCE;
    }

    protected void loadValidations() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurations = registry.getConfigurationElementsFor(MOKA_VALIDATION_EXTENSION_POINT_ID);
        int i = 0;
        while (i < configurations.length) {
            IConfigurationElement config = configurations[i];
            IConfigurationElement[] contexts = config.getChildren(VALIDATION_CONTEXT_CHILD);
            IConfigurationElement[] categories = config.getChildren(VALIDATION_CATEGORY_CHILD);
            int j = 0;
            while (j < categories.length) {
                String category = categories[j].getAttribute(VALIDATION_CATEGORY_ID_ATTRIBUTE);
                ValidationDescriptor validationDescriptor = new ValidationDescriptor(category);
                IConfigurationElement[] excludeConstraints = categories[j].getChildren(VALIDATION_EXCLUDE_CONSTRAINT_CHILD);
                int k = 0;
                while (k < excludeConstraints.length) {
                    String constraint = excludeConstraints[k].getAttribute(VALIDATION_EXCLUDE_CONSTRAINT_ID_ATTRIBUTE);
                    validationDescriptor.addExcludedConstraint(constraint);
                    ++k;
                }
                IConfigurationElement[] excludeCategories = categories[j].getChildren(VALIDATION_EXCLUDE_CATEGORY_CHILD);
                int k2 = 0;
                while (k2 < excludeCategories.length) {
                    String excludeCategory = excludeCategories[k2].getAttribute(VALIDATION_CATEGORY_ID_ATTRIBUTE);
                    validationDescriptor.addExcludedCategory(excludeCategory);
                    ++k2;
                }
                k2 = 0;
                while (k2 < contexts.length) {
                    String contextID = contexts[k2].getAttribute(VALIDATION_CONTEXT_ID_ATTRIBUTE);
                    this.addToRegistry(contextID, validationDescriptor);
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
    }

    public Set<ValidationDescriptor> getValidationDescriptors(String engineID) {
        return this.registry.get(engineID);
    }

    private void addToRegistry(String contextID, ValidationDescriptor validationDescriptor) {
        Set<ValidationDescriptor> descriptors = this.registry.get(contextID);
        if (this.registry.get(contextID) == null) {
            descriptors = new HashSet<ValidationDescriptor>();
            descriptors.add(validationDescriptor);
            this.registry.put(contextID, descriptors);
        } else {
            descriptors.add(validationDescriptor);
        }
    }

    public void clear() {
        this.registry.clear();
    }
}

