/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.service;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.papyrus.moka.debug.messages.DebugEventContextKind;
import org.eclipse.papyrus.moka.debug.messages.DebugRequest;
import org.eclipse.papyrus.moka.debug.messages.ThreadRequest;
import org.eclipse.papyrus.moka.debug.messages.impl.MessagesFactoryImpl;
import org.eclipse.papyrus.moka.debug.service.DebugService;
import org.eclipse.papyrus.moka.debug.service.DebugServiceClientListener;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.kernel.SuspensionReasons;
import org.eclipse.papyrus.moka.kernel.service.ServiceMqttClient;

public class DebugServiceClient
extends ServiceMqttClient {
    private DebugServiceClientListener clientListener;

    public DebugServiceClient(String serverURI, String clientID, DebugService<?, ?> service) {
        super(serverURI, clientID);
        this.clientListener = new DebugServiceClientListener(service);
    }

    public void run() {
        super.run();
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            try {
                ((MqttAsyncClient)this.client).subscribe("debug-target/engine", 1, (IMqttMessageListener)this.clientListener);
                ((MqttAsyncClient)this.client).subscribe("debug-target/thread", 1, (IMqttMessageListener)this.clientListener);
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            try {
                ((MqttAsyncClient)this.client).unsubscribe("debug-target/engine");
                ((MqttAsyncClient)this.client).unsubscribe("debug-target/thread");
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            super.terminate();
        }
    }

    public boolean fireNewThreadEvent(IObject_ object) {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage message = new MqttMessage();
            ThreadRequest request = MessagesFactoryImpl.eINSTANCE.createThreadRequest();
            request.setContextKind(DebugEventContextKind.THREAD);
            request.setEventKind(4);
            request.setThreadId(object.getIdentifier());
            message.setPayload(request.toJson().getBytes());
            message.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-service/thread", message);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    public boolean fireTerminateThreadEvent(IObject_ object) {
        boolean published = false;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage message = new MqttMessage();
            ThreadRequest request = MessagesFactoryImpl.eINSTANCE.createThreadRequest();
            request.setContextKind(DebugEventContextKind.THREAD);
            request.setEventKind(8);
            request.setThreadId(object.getIdentifier());
            message.setPayload(request.toJson().getBytes());
            message.setQos(1);
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-service/thread", message);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }

    public boolean fireSuspendThreadEvent(IObject_ object, ISemanticVisitor visitor) {
        return this.fireSuspendThreadEvent(object, visitor, null);
    }

    public boolean fireSuspendThreadEvent(IObject_ object, ISemanticVisitor visitor, SuspensionReasons reason) {
        boolean published = true;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage message = new MqttMessage();
            ThreadRequest request = MessagesFactoryImpl.eINSTANCE.createThreadRequest();
            request.setContextKind(DebugEventContextKind.THREAD);
            request.setEventKind(2);
            request.setEventDetail(16);
            request.setThreadId(object.getIdentifier());
            request.setSuspensionPoint(visitor.hashCode());
            request.setSuspensionReason(reason);
            message.setPayload(request.toJson().getBytes());
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-service/thread", message);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                try {
                    token.waitForCompletion();
                }
                catch (MqttException e) {
                    published = false;
                    e.printStackTrace();
                }
            }
        }
        return published;
    }

    public boolean fireTerminateEngineEvent() {
        boolean published = true;
        if (this.client != null && ((MqttAsyncClient)this.client).isConnected()) {
            MqttMessage message = new MqttMessage();
            DebugRequest request = MessagesFactoryImpl.eINSTANCE.createDebugRequest();
            request.setContextKind(DebugEventContextKind.ENGINE);
            request.setEventKind(8);
            message.setPayload(request.toJson().getBytes());
            IMqttDeliveryToken token = null;
            try {
                token = this.publish("debug-service/engine", message);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            if (token != null) {
                published = token.isComplete();
            }
        }
        return published;
    }
}

