/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.commonbehavior;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.EventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ICallEventExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ICallEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IReference;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Trigger;

public class CallEventOccurrence
extends EventOccurrence
implements ICallEventOccurrence {
    public ICallEventExecution execution;

    public Operation getOperation() {
        return this.execution.getOperation();
    }

    @Override
    public boolean match(Trigger trigger) {
        boolean matches = false;
        if (trigger.getEvent() instanceof CallEvent) {
            CallEvent callEvent = (CallEvent)trigger.getEvent();
            matches = callEvent.getOperation() == this.getOperation();
        }
        return matches;
    }

    @Override
    public List<IParameterValue> getParameterValues() {
        List<Object> parameterValues = new ArrayList<IParameterValue>();
        if (this.execution != null) {
            parameterValues = this.execution.getInputParameterValues();
        }
        return parameterValues;
    }

    public void suspendCaller() {
        this.execution.setCallerSuspended(true);
    }

    public void returnFromCall() {
        this.execution.setCallerSuspended(false);
    }

    public void setOutputParameterValues(List<IParameterValue> parameterValues) {
        if (this.execution != null) {
            this.execution.setOutputParameterValues(parameterValues);
        }
    }

    @Override
    public void sendTo(IReference target) {
        this.suspendCaller();
        super.sendTo(target);
    }

    public void setCallEventExecution(ICallEventExecution execution) {
        this.execution = execution;
    }

    public ICallEventExecution getCallEventExecution() {
        return this.execution;
    }
}

