/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.animation.animators;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.engine.uml.animation.animators.UMLAnimator;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.additions.IFeatureValueWrapper;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IReference;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.ICS_InteractionPoint;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.additions.ICS_ConnectorLink;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Type;

public class StructuralAnimator
extends UMLAnimator {
    @Override
    public void nodeVisited_(ISemanticVisitor nodeVisitor) {
        if (nodeVisitor instanceof ICS_InteractionPoint) {
            this.engine.renderAs((EObject)((ICS_InteractionPoint)nodeVisitor).getDefiningPort(), ((ICS_InteractionPoint)nodeVisitor).getOwner().getReferent(), AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
        } else if (nodeVisitor instanceof ICS_ConnectorLink) {
            this.engine.renderAs((EObject)((ICS_ConnectorLink)nodeVisitor).getConnector(), null, AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
        } else if (nodeVisitor instanceof IFeatureValueWrapper) {
            IFeatureValueWrapper featureValue = (IFeatureValueWrapper)nodeVisitor;
            this.engine.renderAs((EObject)featureValue.getFeature(), featureValue.getContext(), AnimationKind.VISITED);
        }
    }

    @Override
    public void nodeSuspended_(ISemanticVisitor nodeVisitor) {
        if (nodeVisitor instanceof ICS_InteractionPoint) {
            this.engine.renderAs((EObject)((ICS_InteractionPoint)nodeVisitor).getDefiningPort(), ((ICS_InteractionPoint)nodeVisitor).getOwner().getReferent(), AnimationKind.SUSPENDED);
        } else if (nodeVisitor instanceof ICS_ConnectorLink) {
            this.engine.renderAs((EObject)((ICS_ConnectorLink)nodeVisitor).getConnector(), null, AnimationKind.SUSPENDED);
        } else if (nodeVisitor instanceof IFeatureValueWrapper) {
            IFeatureValueWrapper featureValue = (IFeatureValueWrapper)nodeVisitor;
            this.engine.renderAs((EObject)featureValue.getFeature(), featureValue.getContext(), AnimationKind.SUSPENDED);
        }
    }

    @Override
    public void rtcStepBegin(IReference context) {
        IObject_ referent = context.getReferent();
        if (referent != null) {
            for (Type type : referent.getTypes()) {
                if (!(type instanceof Class) || !((Class)type).isActive()) continue;
                this.engine.renderAs((EObject)type, referent, AnimationKind.ANIMATED);
            }
            ILocus locus = referent.getLocus();
            if (locus != null) {
                for (IExtensionalValue extensionalValue : locus.getExtensionalValues()) {
                    if (!(extensionalValue instanceof IObject_) || referent.getFeatureValues().isEmpty()) continue;
                    for (IFeatureValue featureValue : ((IObject_)extensionalValue).getFeatureValues()) {
                        Iterator valueIterator = featureValue.getValues().iterator();
                        boolean found = false;
                        while (!found && valueIterator.hasNext()) {
                            found = ((IValue)valueIterator.next()).equals((IValue)context);
                        }
                        if (!found) continue;
                        this.engine.renderAs((EObject)featureValue.getFeature(), (IObject_)extensionalValue, AnimationKind.ANIMATED);
                    }
                }
            }
        }
    }

    @Override
    public void rtcStepEnd(IReference context) {
        IObject_ referent = context.getReferent();
        if (referent != null) {
            for (Type type : referent.getTypes()) {
                if (!(type instanceof Class) || !((Class)type).isActive()) continue;
                this.engine.renderAs((EObject)type, referent, AnimationKind.VISITED);
            }
            ILocus locus = referent.getLocus();
            if (locus != null) {
                for (IExtensionalValue extensionalValue : locus.getExtensionalValues()) {
                    if (!(extensionalValue instanceof IObject_) || referent.getFeatureValues().isEmpty()) continue;
                    for (IFeatureValue featureValue : ((IObject_)extensionalValue).getFeatureValues()) {
                        Iterator valueIterator = featureValue.getValues().iterator();
                        boolean found = false;
                        while (!found && valueIterator.hasNext()) {
                            found = ((IValue)valueIterator.next()).equals((IValue)context);
                        }
                        if (!found) continue;
                        this.engine.renderAs((EObject)featureValue.getFeature(), (IObject_)extensionalValue, AnimationKind.VISITED);
                    }
                }
            }
        }
    }

    @Override
    public void valueCreated(IValue value) {
        if (value instanceof IObject_) {
            for (Classifier classifier : ((IObject_)value).getTypes()) {
                this.engine.renderAs((EObject)classifier, (IObject_)value, AnimationKind.VISITED);
            }
        }
    }

    @Override
    public void valueDestroyed(IValue value) {
        if (value instanceof IObject_) {
            for (Classifier classifier : ((IObject_)value).getTypes()) {
                ILocus locus = ((IObject_)value).getLocus();
                if (locus == null || !locus.getExtent(classifier).isEmpty()) continue;
                this.engine.removeRenderingRules((EObject)classifier);
            }
        }
    }

    @Override
    public void nodeLeft_(ISemanticVisitor nodeVisitor) {
    }

    public boolean accept(Object object) {
        if (object instanceof ICS_InteractionPoint) {
            return true;
        }
        if (object instanceof ICS_ConnectorLink) {
            return true;
        }
        if (object instanceof IFeatureValue) {
            return true;
        }
        if (object instanceof IObject_) {
            return true;
        }
        return object instanceof IReference;
    }
}

