/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>IMarkup To File Body Part Template</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getInputFormat <em>Input Format</em>}</li>
 * <li>{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getOutputFomat <em>Output Fomat</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage#getIMarkupToFileBodyPartTemplate()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface IMarkupToFileBodyPartTemplate extends IBodySectionPartTemplate {
	/**
	 * Returns the value of the '<em><b>Input Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The format of the used markup (markdown:md, wiki:mediawiki,...)
	 * <!-- end-model-doc -->
	 *
	 * @return the value of the '<em>Input Format</em>' attribute.
	 * @see #setInputFormat(String)
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage#getIMarkupToFileBodyPartTemplate_InputFormat()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getInputFormat();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getInputFormat <em>Input Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Input Format</em>' attribute.
	 * @see #getInputFormat()
	 * @generated
	 */
	void setInputFormat(String value);

	/**
	 * Returns the value of the '<em><b>Output Fomat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The format of the output file (html for example).
	 * <!-- end-model-doc -->
	 *
	 * @return the value of the '<em>Output Fomat</em>' attribute.
	 * @see #setOutputFomat(String)
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage#getIMarkupToFileBodyPartTemplate_OutputFomat()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getOutputFomat();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate#getOutputFomat <em>Output Fomat</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Output Fomat</em>' attribute.
	 * @see #getOutputFomat()
	 * @generated
	 */
	void setOutputFomat(String value);

} // IMarkupToFileBodyPartTemplate
