/*****************************************************************************
 * Copyright (c) 2020, 2025 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - GL-9
 *****************************************************************************/

package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.viewpoint;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;

/**
 * Interface for ViewPrototype to get the result of the instantiation instead of a boolean
 * TODO : propose me to Papyrus
 */
public interface ExtendedViewPrototype<T extends EObject> {

	/**
	 *
	 * @param semanticOwner
	 *            the semantic owner of the instantiated view
	 * @param graphicalOwner
	 *            the graphical owner of the instantiated view
	 * @param name
	 *            the name of the instantiated view
	 * @param openCreatedView
	 *            if <code>true</code> the created view will be open
	 * @param logger
	 *            the logger used to log the messages during the process
	 * @return
	 *         the instantiated view
	 */
	public T instantiateOn(EObject semanticOwner, EObject graphicalOwner, String name, boolean openCreatedView, final IModel2DocLogger logger);

}
