/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.TextDocumentTemplate;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.commands.AbstractCreatePapyrusEditorViewCommand;

public class CreateDocumentTemplateEditorViewCommand
extends AbstractCreatePapyrusEditorViewCommand<DocumentTemplate> {
    private final DocumentTemplatePrototype prototype;
    private final String mainTitle;

    public CreateDocumentTemplateEditorViewCommand(TransactionalEditingDomain domain, DocumentTemplatePrototype documentTemplatePrototype, String documentName, String documentMainTitle, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, IModel2DocLogger logger) {
        super(domain, "Create new DocumentTemplate", documentName, semanticContext, graphicalContext, openAfterCreation, logger);
        this.prototype = documentTemplatePrototype;
        this.mainTitle = documentMainTitle;
    }

    public CreateDocumentTemplateEditorViewCommand(TransactionalEditingDomain domain, DocumentTemplatePrototype documentTemplatePrototype, String documentName, String documentMainTitle, EObject semanticContext, boolean openAfterCreation, IModel2DocLogger logger) {
        this(domain, documentTemplatePrototype, documentName, documentMainTitle, semanticContext, null, openAfterCreation, logger);
    }

    protected void doExecute() {
        DocumentTemplate template = this.prototype.getDocumentTemplate();
        DocumentTemplate newInstance = (DocumentTemplate)EcoreUtil.copy((EObject)template);
        if (newInstance instanceof TextDocumentTemplate) {
            ((TextDocumentTemplate)newInstance).setMainTitle(this.mainTitle);
        }
        if (this.graphicalContext != null) {
            this.attachToResource(this.graphicalContext, newInstance);
        } else {
            this.attachToResource(this.semanticContext, newInstance);
        }
        IDocumentStructureGeneratorConfiguration generator = newInstance.getDocumentStructureGeneratorConfiguration();
        if (generator != null) {
            generator.setDocumentName(this.editorViewName);
        }
        newInstance.setDocumentTemplatePrototype(this.prototype);
        newInstance.setGraphicalContext(this.graphicalContext);
        newInstance.setSemanticContext(this.semanticContext);
        newInstance.setName(this.editorViewName);
        if (this.openAfterCreation) {
            this.openEditor(newInstance);
        }
        if (newInstance.eResource() != null) {
            this.createdEditorView = newInstance;
        }
    }
}

