/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.runtime;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.xwt.XWTSection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.ISection;

public class EmbeddedDisplayEngine
extends DefaultDisplayEngine
implements SelectionListener {
    private String lastTabId;
    protected CTabFolder currentFolder;
    protected Composite self;
    protected Set<ISection> displayedSections = new HashSet<ISection>();

    /*
     * WARNING - void declaration
     */
    public void display(Set<? extends View> views, Composite parent, ISelection selection, int style) {
        this.disposeControls();
        this.self = new Composite(parent, 0);
        this.self.setLayout((Layout)new FillLayout());
        final LinkedHashSet<Tab> tabsList = new LinkedHashSet<Tab>();
        for (View view : views) {
            for (Section section : view.getSections()) {
                tabsList.add(section.getTab());
            }
        }
        LinkedList linkedList = new LinkedList(tabsList);
        Collections.sort(linkedList, new Comparator<Tab>(){

            @Override
            public int compare(Tab tab1, Tab tab2) {
                int priority2;
                int priority1 = this.getPriority(tab1);
                if (priority1 < (priority2 = this.getPriority(tab2))) {
                    return -1;
                }
                if (priority1 > priority2) {
                    return 1;
                }
                priority1 = this.getXWTTabPriority(tab1);
                if (priority1 < (priority2 = this.getXWTTabPriority(tab2))) {
                    return -1;
                }
                if (priority1 > priority2) {
                    return 1;
                }
                String label1 = tab1.getLabel();
                String label2 = tab2.getLabel();
                return Collator.getInstance().compare(label1, label2);
            }

            private Tab getPreviousTab(Tab tab) {
                Tab afterTab = tab.getAfterTab();
                if (tabsList.contains(afterTab)) {
                    return afterTab;
                }
                return null;
            }

            private int getPriority(Tab tab) {
                Tab previousTab = this.getPreviousTab(tab);
                if (previousTab != null) {
                    return this.getPriority(previousTab) + 1;
                }
                return this.getXWTTabPriority(tab);
            }

            private int getXWTTabPriority(Tab tab) {
                return tab.getPriority();
            }
        });
        LinkedHashMap<Tab, Composite> tabs = new LinkedHashMap<Tab, Composite>();
        if (linkedList.size() > 1) {
            void var8_14;
            void var8_11;
            Object var8_10 = null;
            this.currentFolder = new CTabFolder(this.self, style);
            this.currentFolder.setSelectionBackground(new Color[]{this.currentFolder.getDisplay().getSystemColor(1), this.currentFolder.getBackground()}, new int[]{100}, true);
            this.currentFolder.setLayout((Layout)new FillLayout());
            for (Tab tab : linkedList) {
                CTabItem item = new CTabItem(this.currentFolder, 0);
                Composite tabControl = new Composite((Composite)this.currentFolder, 0);
                item.setControl((Control)tabControl);
                item.setText(tab.getLabel());
                item.setData("id", (Object)tab.getId());
                if (tab.getId().equals(this.lastTabId)) {
                    CTabItem cTabItem = item;
                }
                tabs.put(tab, tabControl);
            }
            this.currentFolder.addSelectionListener((SelectionListener)this);
            if (var8_11 == null) {
                CTabItem cTabItem = this.currentFolder.getItem(0);
            }
            this.currentFolder.setSelection((CTabItem)var8_14);
        } else if (!linkedList.isEmpty()) {
            Tab tab = (Tab)linkedList.get(0);
            tabs.put(tab, this.self);
        } else {
            return;
        }
        for (View view : views) {
            for (Section section : view.getSections()) {
                XWTSection xwtSection = new XWTSection(section, view, this);
                xwtSection.createControls((Composite)tabs.get(section.getTab()), null);
                xwtSection.setInput(null, selection);
                xwtSection.refresh();
                this.displayedSections.add((ISection)xwtSection);
            }
        }
        this.self.layout();
    }

    @Override
    protected void disposeControls() {
        super.disposeControls();
        if (this.self != null) {
            this.self.dispose();
            this.self = null;
            this.currentFolder = null;
        }
        for (ISection section : this.displayedSections) {
            section.dispose();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        CTabFolder folder;
        CTabItem lastTab;
        Object lastId;
        if (e.widget instanceof CTabFolder && (lastId = (lastTab = (folder = (CTabFolder)e.widget).getSelection()).getData("id")) != null && lastId instanceof String) {
            this.lastTabId = (String)lastId;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

