/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.initializer;

import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractViewInitializer {
    private final View view;
    private final IPreferenceStore store;

    public AbstractViewInitializer(View view, IPreferenceStore store) {
        this.view = view;
        this.store = store;
    }

    public void initFont(String preferenceFontName) {
        FontStyle fontStyle = (FontStyle)this.view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (fontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.store, (String)preferenceFontName);
            fontStyle.setFontName(fontData.getName());
            fontStyle.setFontHeight(fontData.getHeight());
            fontStyle.setBold((fontData.getStyle() & 1) != 0);
            fontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)this.store, (String)preferenceFontName);
            fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    public void initFontColor(String preferenceFontColorName) {
        FontStyle fontStyle = (FontStyle)this.view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (fontStyle != null) {
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)this.store, (String)preferenceFontColorName);
            fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    public void initLineColor(String preferenceLineColorName) {
        LineStyle lineStyle = (LineStyle)this.view.getStyle(NotationPackage.Literals.LINE_STYLE);
        if (lineStyle != null) {
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)this.store, (String)preferenceLineColorName);
            lineStyle.setLineColor(FigureUtilities.RGBToInteger((RGB)lineRGB).intValue());
        }
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public View getView() {
        return this.view;
    }
}

