/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.services.markerlistener.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerProviderRegistry {
    private static final String EXT_POINT = "markerproviders";
    public static final MarkerProviderRegistry INSTANCE = new MarkerProviderRegistry();
    private final List<IMarkerProvider> providers = new ArrayList<IMarkerProvider>();
    private boolean needPrune;

    private MarkerProviderRegistry() {
        new MyRegistryReader().readRegistry();
    }

    private void prune() {
        if (this.needPrune) {
            this.needPrune = false;
            ListIterator<IMarkerProvider> iter = this.providers.listIterator();
            while (iter.hasNext()) {
                MyRegistryReader.Descriptor desc;
                IMarkerProvider next = iter.next();
                if (next == IMarkerProvider.NULL) {
                    iter.remove();
                    continue;
                }
                if (!(next instanceof MyRegistryReader.Descriptor) || (desc = (MyRegistryReader.Descriptor)next).instance == null) continue;
                iter.set(desc.instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IMarkerProvider getMarkerProvider(Resource resource) {
        IMarkerProvider result = IMarkerProvider.NULL;
        List<IMarkerProvider> list = this.providers;
        synchronized (list) {
            this.prune();
            for (IMarkerProvider next : this.providers) {
                if (!next.canProvideMarkersFor(resource)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMarkerProvider> getMarkerProviders(Resource resource) {
        LinkedList<IMarkerProvider> result = new LinkedList<IMarkerProvider>();
        List<IMarkerProvider> list = this.providers;
        synchronized (list) {
            this.prune();
            for (IMarkerProvider next : this.providers) {
                if (!next.canProvideMarkersFor(resource)) continue;
                result.add(next);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProvider(String className) {
        List<IMarkerProvider> list = this.providers;
        synchronized (list) {
            Iterator<IMarkerProvider> iter = this.providers.iterator();
            while (iter.hasNext()) {
                IMarkerProvider next = iter.next();
                if (next instanceof MyRegistryReader.Descriptor) {
                    MyRegistryReader.Descriptor desc = (MyRegistryReader.Descriptor)next;
                    if (!className.equals(desc.getClassName())) continue;
                    iter.remove();
                    break;
                }
                if (!className.equals(next.getClass().getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    private class MyRegistryReader
    extends RegistryReader {
        private static final String E_ENABLEMENT = "enablement";
        private static final String A_CLASS = "class";
        private static final String E_PROVIDER = "provider";
        private Descriptor currentDescriptor;
        private boolean inEnablement;

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.services.markerlistener", MarkerProviderRegistry.EXT_POINT);
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            return add ? this.handleAdd(element) : this.handleRemove(element);
        }

        private boolean handleAdd(IConfigurationElement element) {
            boolean result = false;
            if (E_PROVIDER.equals(element.getName())) {
                this.inEnablement = false;
                if (element.getAttribute(A_CLASS) == null) {
                    this.logMissingAttribute(element, A_CLASS);
                } else {
                    this.currentDescriptor = new Descriptor(element, A_CLASS);
                    MarkerProviderRegistry.this.providers.add(this.currentDescriptor);
                }
                result = true;
            } else if (E_ENABLEMENT.equals(element.getName())) {
                if (this.currentDescriptor != null) {
                    this.inEnablement = true;
                    try {
                        this.currentDescriptor.setMatchResourceExpression(ExpressionConverter.getDefault().perform(element));
                        result = true;
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            } else {
                result = this.inEnablement;
            }
            return result;
        }

        private boolean handleRemove(IConfigurationElement element) {
            boolean result = true;
            if (E_PROVIDER.equals(element.getName())) {
                String className = element.getAttribute(A_CLASS);
                if (className == null) {
                    this.logMissingAttribute(element, A_CLASS);
                    result = false;
                } else {
                    MarkerProviderRegistry.this.removeProvider(className);
                }
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Descriptor
        extends RegistryReader.PluginClassDescriptor
        implements IMarkerProvider {
            private Expression matchResource;
            private IMarkerProvider instance;

            Descriptor(IConfigurationElement element, String attributeName) {
                super(element, attributeName);
            }

            String getClassName() {
                return this.element.getAttribute(this.attributeName);
            }

            void setMatchResourceExpression(Expression expression) {
                this.matchResource = expression;
            }

            IMarkerProvider getInstance() {
                if (this.instance == null) {
                    try {
                        this.instance = (IMarkerProvider)this.createInstance();
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to instantiate marker provider extension.", (Throwable)e);
                        this.instance = IMarkerProvider.NULL;
                    }
                    MarkerProviderRegistry.this.needPrune = true;
                }
                return this.instance;
            }

            @Override
            public boolean canProvideMarkersFor(Resource resource) {
                return this.instance == null ? this.evaluateEnablement(resource) : this.instance.canProvideMarkersFor(resource);
            }

            private boolean evaluateEnablement(Resource resource) {
                boolean result;
                if (this.matchResource != null) {
                    EvaluationContext ctx = new EvaluationContext(null, (Object)resource);
                    ctx.addVariable("isFile", (Object)(MarkerListenerUtils.getFile(resource) != null ? 1 : 0));
                    EvaluationResult evalResult = EvaluationResult.FALSE;
                    try {
                        evalResult = this.matchResource.evaluate((IEvaluationContext)ctx);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                    result = EvaluationResult.TRUE.equals(evalResult);
                } else {
                    result = this.getInstance().canProvideMarkersFor(resource);
                }
                return result;
            }

            @Override
            public Collection<? extends IPapyrusMarker> getMarkers(Resource resource, String type, boolean includeSubtypes) throws CoreException {
                return this.getInstance().getMarkers(resource, type, includeSubtypes);
            }

            @Override
            public void createMarkers(Resource resource, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
                this.getInstance().createMarkers(resource, diagnostic, monitor);
            }

            @Override
            @Deprecated
            public void deleteMarkers(EObject object, IProgressMonitor monitor) throws CoreException {
                this.getInstance().deleteMarkers(object, monitor);
            }

            @Override
            @Deprecated
            public void deleteMarkers(Resource resource, IProgressMonitor monitor) throws CoreException {
                this.getInstance().deleteMarkers(resource, monitor);
            }

            @Override
            public void deleteMarkers(EObject object, IProgressMonitor monitor, String markerType, boolean includeSubtypes) throws CoreException {
                this.getInstance().deleteMarkers(object, monitor, markerType, includeSubtypes);
            }

            @Override
            public void deleteMarkers(Resource resource, IProgressMonitor monitor, String markerType, boolean includeSubtypes) throws CoreException {
                this.getInstance().deleteMarkers(resource, monitor, markerType, includeSubtypes);
            }
        }
    }
}

