/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml16.blocks.Block;
import org.eclipse.papyrus.sysml16.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml16.service.types.util.UMLConnectorUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConnectorUtil {
    public static final UMLConnectorUtils umlUtility = new UMLConnectorUtils();
    public static final String NESTED_CONNECTOR_END_PATH = "connectorEndPath";
    public static final String PART_SEPARATOR = ".";
    public static final String HAS_NO_WORD_CHAR_REGEX = "\\W+";
    public static final String STRING_DELIMITER = "'";

    private ConnectorUtil() {
    }

    public static View getEncapsulatedContainer(View view) {
        View encapsulatedContainer = null;
        for (View containerView : umlUtility.getStructureContainers(view)) {
            StructuredClassifier structuredClassifier;
            Block block;
            if (view == containerView || view.getElement() instanceof Port && containerView.getChildren().contains((Object)view) || (block = (Block)UMLUtil.getStereotypeApplication((Element)(structuredClassifier = umlUtility.getStructuredClassifier(containerView)), Block.class)) == null || !block.isEncapsulated()) continue;
            encapsulatedContainer = containerView;
            break;
        }
        return encapsulatedContainer;
    }

    public static boolean isCrossingEncapsulation(View checkedEnd, View oppositeEnd) {
        boolean isCrossingEncapsulation = false;
        View encapsulatedContainer = ConnectorUtil.getEncapsulatedContainer(checkedEnd);
        if (encapsulatedContainer != null) {
            View containerView = umlUtility.deduceViewContainer(checkedEnd, oppositeEnd);
            List containers = umlUtility.getStructureContainers(checkedEnd);
            if (containers.indexOf(encapsulatedContainer) < containers.indexOf(containerView)) {
                isCrossingEncapsulation = true;
            }
        }
        return isCrossingEncapsulation;
    }

    public static final String getRolePath(ConnectorEnd end) {
        NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)end, NestedConnectorEnd.class);
        ConnectableElement role = end.getRole();
        StringBuilder rolePath = new StringBuilder();
        if (role != null) {
            if (nestedConnectorEnd != null) {
                EList properties = nestedConnectorEnd.getPropertyPath();
                for (Property current : properties) {
                    rolePath.append(UMLConnectorUtils.getNameWithQuotes((NamedElement)current));
                    rolePath.append(PART_SEPARATOR);
                }
            } else {
                Property partWithPort = end.getPartWithPort();
                if (partWithPort != null) {
                    rolePath.append(UMLConnectorUtils.getNameWithQuotes((NamedElement)partWithPort));
                    rolePath.append(PART_SEPARATOR);
                }
            }
            rolePath.append(UMLConnectorUtils.getNameWithQuotes((NamedElement)role));
        }
        return rolePath.toString();
    }

    public static final boolean isCrossingEncapuslation(List<Property> nestedPath) {
        for (ConnectableElement connectableElement : nestedPath) {
            Block block;
            Type type = connectableElement.getType();
            if (type == null || (block = (Block)UMLUtil.getStereotypeApplication((Element)type, Block.class)) == null || !block.isEncapsulated()) continue;
            return true;
        }
        return false;
    }

    public static boolean canDisplayExistingConnectorBetweenViewsAccordingToNestedPaths(Connector connector, View sourceView, View targetView) {
        List<Property> sourcePath = umlUtility.getNestedPropertyPath(sourceView, targetView);
        List<Property> targetPath = umlUtility.getNestedPropertyPath(targetView, sourceView);
        boolean hasWantedPath = true;
        for (ConnectorEnd end : connector.getEnds()) {
            if (sourceView != null && end.getRole() == sourceView.getElement()) {
                hasWantedPath = hasWantedPath && ConnectorUtil.haveSamePath(sourcePath, end);
                continue;
            }
            if (targetView == null || end.getRole() != targetView.getElement()) continue;
            boolean bl = hasWantedPath = hasWantedPath && ConnectorUtil.haveSamePath(targetPath, end);
        }
        return hasWantedPath;
    }

    protected static boolean haveSamePath(List<Property> wantedPath, ConnectorEnd end) {
        NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)end, NestedConnectorEnd.class);
        if (nestedConnectorEnd != null) {
            return nestedConnectorEnd.getPropertyPath().equals(wantedPath);
        }
        return wantedPath.isEmpty();
    }

    public static List<Connector> filterConnectorByPropertyInNestedConnectorEnd(List<Connector> connectors, Property part) {
        ArrayList<Connector> res = new ArrayList<Connector>();
        for (Connector connector : connectors) {
            EList ends = connector.getEnds();
            for (ConnectorEnd connectorEnd : ends) {
                NestedConnectorEnd stereotypeApplication = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)connectorEnd, NestedConnectorEnd.class);
                if (stereotypeApplication == null) continue;
                EList propertyPath = stereotypeApplication.getPropertyPath();
                for (Property property : propertyPath) {
                    if (!property.equals(part)) continue;
                    res.add(connector);
                }
            }
        }
        return res;
    }

    public static List<Property> getNestedPath(Class clazz, View view) {
        ArrayList<Property> propertyPath = new ArrayList<Property>();
        View currentView = ViewUtil.getContainerView((View)view);
        boolean stop = false;
        while (!stop && currentView != null) {
            EObject property = currentView.getElement();
            if (property instanceof Property) {
                if (((Property)property).getType() == clazz) {
                    stop = true;
                } else {
                    propertyPath.add((Property)property);
                }
            } else if (clazz.equals(currentView.getElement())) {
                stop = true;
            }
            currentView = ViewUtil.getContainerView((View)currentView);
        }
        Collections.reverse(propertyPath);
        return propertyPath;
    }
}

