/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.threadgroups;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetProxy;
import org.eclipse.debug.internal.ui.viewers.update.StackFrameEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.ui.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaElementContentProvider;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jdt.internal.debug.ui.threadgroups.JavaThreadEventHandler;
import org.eclipse.jface.viewers.Viewer;

public class JavaDebugTargetProxy
extends DebugTargetProxy {
    private JavaThreadEventHandler fThreadEventHandler;
    private boolean fIsScrapbook = false;
    private IDebugTarget fDebugTarget = null;

    public JavaDebugTargetProxy(IDebugTarget target) {
        super(target);
        this.fDebugTarget = target;
        ILaunch launch = target.getLaunch();
        if (launch != null) {
            this.fIsScrapbook = launch.getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) != null;
        }
    }

    protected DebugEventHandler[] createEventHandlers() {
        this.fThreadEventHandler = new JavaThreadEventHandler((AbstractModelProxy)this);
        return new DebugEventHandler[]{new DebugTargetEventHandler((AbstractModelProxy)this), this.fThreadEventHandler, new StackFrameEventHandler((AbstractModelProxy)this, (ThreadEventHandler)this.fThreadEventHandler)};
    }

    public void installed(Viewer viewer) {
        if (this.fIsScrapbook) {
            return;
        }
        final Viewer finalViewer = viewer;
        Job job = new Job("Initialize Java Debug Session"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!JavaDebugTargetProxy.this.isDisposed()) {
                    JavaDebugTargetProxy.this.doInstalled(finalViewer);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JavaDebugTargetProxy.this == family;
            }
        };
        job.setSystem(true);
        job.schedule(500L);
        this.fThreadEventHandler.init(viewer);
    }

    private void doInstalled(Viewer viewer) {
        IDebugTarget target = this.fDebugTarget;
        if (target != null) {
            ModelDelta delta = this.getNextSuspendedThreadDelta(null, false);
            if (delta == null) {
                try {
                    ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunch launch = target.getLaunch();
                    int launchIndex = this.indexOf(manager.getLaunches(), target.getLaunch());
                    int targetIndex = this.indexOf(target.getLaunch().getChildren(), target);
                    delta = new ModelDelta((Object)manager, 0);
                    ModelDelta node = delta.addNode((Object)launch, launchIndex, 0, target.getLaunch().getChildren().length);
                    node = node.addNode((Object)target, targetIndex, 0x300000, this.getTargetChildCount(target));
                }
                catch (DebugException debugException) {
                    return;
                }
            }
            this.fireModelChanged((IModelDelta)delta);
        }
    }

    private int getTargetChildCount(IDebugTarget target) throws DebugException {
        if (target instanceof IJavaDebugTarget) {
            IJavaDebugTarget javaTarget = (IJavaDebugTarget)target;
            if (JavaElementContentProvider.isDisplayThreadGroups()) {
                if (javaTarget.isDisconnected() || javaTarget.isTerminated()) {
                    return 0;
                }
                return javaTarget.getRootThreadGroups().length;
            }
            return javaTarget.getThreads().length;
        }
        return 0;
    }

    protected int getStackFrameIndex(IStackFrame stackFrame) {
        int stackFrameIndex = 0;
        if (((IJavaDebugTarget)this.fDebugTarget).supportsMonitorInformation()) {
            IThread thread = stackFrame.getThread();
            IDebugElement[] ownedMonitors = JavaDebugUtils.getOwnedMonitors(thread);
            stackFrameIndex += ownedMonitors.length;
            IDebugElement contendedMonitor = JavaDebugUtils.getContendedMonitor(thread);
            if (contendedMonitor != null) {
                ++stackFrameIndex;
            }
        }
        return stackFrameIndex;
    }
}

