/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupExpandCollapseLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;

public class ColumnGroupExpandCollapseCommandHandler
extends AbstractLayerCommandHandler<ColumnGroupExpandCollapseCommand> {
    private final ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer;

    public ColumnGroupExpandCollapseCommandHandler(ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer) {
        this.columnGroupExpandCollapseLayer = columnGroupExpandCollapseLayer;
    }

    @Override
    public Class<ColumnGroupExpandCollapseCommand> getCommandClass() {
        return ColumnGroupExpandCollapseCommand.class;
    }

    @Override
    protected boolean doCommand(ColumnGroupExpandCollapseCommand command) {
        int columnIndex = this.columnGroupExpandCollapseLayer.getColumnIndexByPosition(command.getColumnPosition());
        ColumnGroupModel model = this.columnGroupExpandCollapseLayer.getModel(command.getRowPosition());
        ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
        if (columnGroup == null || !columnGroup.isCollapseable()) {
            return true;
        }
        ArrayList<Integer> columnIndexes = new ArrayList<Integer>(columnGroup.getMembers());
        columnIndexes.removeAll(columnGroup.getStaticColumnIndexes());
        boolean wasCollapsed = columnGroup.isCollapsed();
        if (wasCollapsed) {
            this.cleanupColumnIndexes(columnIndexes);
        }
        columnGroup.toggleCollapsed();
        if (!wasCollapsed) {
            this.cleanupColumnIndexes(columnIndexes);
        }
        ColumnStructuralChangeEvent event = wasCollapsed ? new ShowColumnPositionsEvent(this.columnGroupExpandCollapseLayer, columnIndexes) : new HideColumnPositionsEvent((ILayer)this.columnGroupExpandCollapseLayer, (Collection<Integer>)columnIndexes);
        this.columnGroupExpandCollapseLayer.fireLayerEvent(event);
        return true;
    }

    private void cleanupColumnIndexes(List<Integer> columnIndexes) {
        Iterator<Integer> it = columnIndexes.iterator();
        while (it.hasNext()) {
            Integer columnIndex = it.next();
            if (this.columnGroupExpandCollapseLayer.isColumnIndexHidden(columnIndex)) continue;
            it.remove();
        }
    }
}

