/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.OutputStream;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirrorImpl;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class TearDownOnVmCrash
implements JUnitResultFormatter {
    private String suiteName;

    @Override
    public void startTestSuite(JUnitTest suite) {
        this.suiteName = suite.getName();
        if (this.suiteName != null && this.suiteName.endsWith("Batch-With-Multiple-Tests")) {
            this.suiteName = null;
        }
    }

    public void addError(Test fakeTest, Throwable t) {
        if (this.suiteName != null && fakeTest instanceof JUnitTaskMirrorImpl.VmExitErrorTest) {
            this.tearDown();
        }
    }

    public void addFailure(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    @Override
    public void endTestSuite(JUnitTest suite) {
    }

    @Override
    public void setOutput(OutputStream out) {
    }

    @Override
    public void setSystemOutput(String out) {
    }

    @Override
    public void setSystemError(String err) {
    }

    private void tearDown() {
        try {
            Class<?> testClass = null;
            if (Thread.currentThread().getContextClassLoader() != null) {
                try {
                    testClass = Thread.currentThread().getContextClassLoader().loadClass(this.suiteName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (testClass == null && this.getClass().getClassLoader() != null) {
                try {
                    testClass = this.getClass().getClassLoader().loadClass(this.suiteName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (testClass == null) {
                testClass = Class.forName(this.suiteName);
            }
            try {
                testClass.getMethod("suite", new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method td = testClass.getMethod("tearDown", new Class[0]);
                    if (td.getReturnType() == Void.TYPE) {
                        td.invoke(testClass.newInstance(), new Object[0]);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException2) {}
            }
        }
        catch (ClassNotFoundException testClass) {
        }
        catch (Throwable t) {
            System.err.println("Caught an exception while trying to invoke tearDown: " + t.getMessage());
        }
    }
}

