/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swt.DefaultItemFormat;
import ca.odell.glazedlists.swt.ItemFormat;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventComboViewer<E>
implements ListEventListener<E> {
    private boolean disposeSource;
    private Combo combo;
    protected EventList<E> source;
    private ItemFormat<? super E> itemFormat;

    public DefaultEventComboViewer(EventList<E> source, Combo combo) {
        this(source, combo, new DefaultItemFormat());
    }

    public DefaultEventComboViewer(EventList<E> source, Combo combo, ItemFormat<? super E> itemFormat) {
        this(source, combo, itemFormat, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultEventComboViewer(EventList<E> source, Combo combo, ItemFormat<? super E> itemFormat, boolean disposeSource) {
        this.disposeSource = disposeSource;
        source.getReadWriteLock().readLock().lock();
        try {
            this.source = source;
            this.combo = combo;
            this.itemFormat = itemFormat;
            int n = source.size();
            for (int i = 0; i < n; ++i) {
                this.addRow(i, source.get(i));
            }
            this.source.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public Combo getCombo() {
        return this.combo;
    }

    public ItemFormat<? super E> getItemFormat() {
        return this.itemFormat;
    }

    private void addRow(int row, E value) {
        this.combo.add(this.itemFormat.format(value), row);
    }

    private void updateRow(int row, E value) {
        this.combo.setItem(row, this.itemFormat.format(value));
    }

    private void deleteRow(int row) {
        this.combo.remove(row);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                this.addRow(changeIndex, this.source.get(changeIndex));
                continue;
            }
            if (changeType == 1) {
                this.updateRow(changeIndex, this.source.get(changeIndex));
                continue;
            }
            if (changeType != 0) continue;
            this.deleteRow(changeIndex);
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
    }
}

