/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.RemoteFeaturesAction;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.osgi.util.NLS;

public class RemoteUpdateSiteAction
implements IPublisherAction {
    private UpdateSite updateSite;
    private final String categoryQualifier;

    public RemoteUpdateSiteAction(UpdateSite updateSite, String categoryQualifier) {
        this.updateSite = updateSite;
        this.categoryQualifier = categoryQualifier;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        if (Tracing.DEBUG_PUBLISHING) {
            Tracing.debug((String)("Generating metadata for update site: " + this.updateSite.getLocation()));
        }
        IPublisherAction[] actions = this.createActions();
        MultiStatus finalStatus = new MultiStatus(this.getClass().getName(), 0, NLS.bind((String)Messages.Error_Generation, (Object)(this.updateSite != null ? this.updateSite.getLocation().toString() : "Unknown")), null);
        int i = 0;
        while (i < actions.length) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            finalStatus.merge(actions[i].perform(info, results, monitor));
            ++i;
        }
        if (Tracing.DEBUG_PUBLISHING) {
            Tracing.debug((String)("Generation for update site complete: " + this.updateSite.getLocation()));
        }
        if (!finalStatus.isOK()) {
            return finalStatus;
        }
        return Status.OK_STATUS;
    }

    protected IPublisherAction[] createActions() {
        ArrayList<RemoteFeaturesAction> result = new ArrayList<RemoteFeaturesAction>();
        result.add(new RemoteFeaturesAction(this.updateSite));
        result.add((RemoteFeaturesAction)this.createSiteXMLAction());
        return result.toArray(new IPublisherAction[result.size()]);
    }

    private IPublisherAction createSiteXMLAction() {
        return new SiteXMLAction(this.updateSite, this.categoryQualifier);
    }
}

