/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sashwindows.di.util;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.CompositePageRemovalValidator;

@FunctionalInterface
public interface PageRemovalValidator {
    public static final PageRemovalValidator ALWAYS_REMOVE = new PageRemovalValidator(){

        @Override
        public boolean canRemovePage(PageRef page) {
            return true;
        }

        @Override
        public Collection<? extends PageRef> filterRemovablePages(Collection<? extends PageRef> pages) {
            return pages;
        }
    };

    public boolean canRemovePage(PageRef var1);

    default public Collection<? extends PageRef> filterRemovablePages(Collection<? extends PageRef> pages) {
        return pages.stream().filter(this::canRemovePage).collect(Collectors.toList());
    }

    default public PageRemovalValidator compose(PageRemovalValidator other) {
        return new CompositePageRemovalValidator(this, other);
    }

    public static PageRemovalValidator getInstance(Notifier notifier) {
        return notifier.eAdapters().stream().filter(PageRemovalValidator.class::isInstance).map(PageRemovalValidator.class::cast).reduce(PageRemovalValidator::compose).orElse(ALWAYS_REMOVE);
    }
}

