/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public abstract class ExecutionSpecificationEditHelper
extends ElementEditHelper {
    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        CompositeCommand deleteElementsCommand = new CompositeCommand(req.getLabel());
        EObject elementToDestroy = req.getElementToDestroy();
        ICommand deleteCommand = super.getDestroyElementCommand(req);
        if (deleteCommand != null) {
            deleteElementsCommand.add((IUndoableOperation)deleteCommand);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)elementToDestroy);
            if (provider != null && elementToDestroy instanceof ExecutionSpecification) {
                ExecutionSpecification es = (ExecutionSpecification)elementToDestroy;
                this.destroyIntermediateInteractionFragments(es, req.getEditingDomain(), deleteElementsCommand);
                if (es.getStart() != null && !(es.getStart() instanceof MessageEnd)) {
                    DestroyElementRequest delStart = new DestroyElementRequest(req.getEditingDomain(), (EObject)es.getStart(), false);
                    deleteElementsCommand.add((IUndoableOperation)new DestroyElementCommand(delStart));
                }
                if (es.getFinish() != null && !(es.getFinish() instanceof MessageEnd)) {
                    DestroyElementRequest delEnd = new DestroyElementRequest(req.getEditingDomain(), (EObject)es.getFinish(), false);
                    deleteElementsCommand.add((IUndoableOperation)new DestroyElementCommand(delEnd));
                }
            }
        }
        if (deleteElementsCommand.size() > 0) {
            return deleteElementsCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected void destroyIntermediateInteractionFragments(ExecutionSpecification es, TransactionalEditingDomain editingDomain, CompositeCommand compositeCommand) {
        Lifeline coveredLifeline;
        OccurrenceSpecification start = es.getStart();
        OccurrenceSpecification finish = es.getFinish();
        if (start != null && finish != null && (coveredLifeline = start.getCovered()) != null) {
            EList fragments = Collections.emptyList();
            Interaction startEnclosingInteraction = start.getEnclosingInteraction();
            InteractionOperand startEnclosingOperand = start.getEnclosingOperand();
            if (startEnclosingInteraction != null) {
                fragments = startEnclosingInteraction.getFragments();
            } else if (startEnclosingOperand != null) {
                fragments = startEnclosingOperand.getFragments();
            }
            Element container = es.getOwner();
            int indexOfStart = -1;
            indexOfStart = container instanceof Interaction ? ((Interaction)container).getFragments().indexOf((Object)start) : ((InteractionOperand)container).getFragments().indexOf((Object)start);
            if (indexOfStart != -1) {
                List<InteractionFragment> fragmentsToProcess = fragments.subList(indexOfStart, fragments.size() - 1);
                List<InteractionFragment> result = this.findIntermediates(fragmentsToProcess, finish, coveredLifeline, false);
                for (InteractionFragment interactionFragment : result) {
                    if (interactionFragment instanceof MessageOccurrenceSpecification) {
                        Message message = ((MessageOccurrenceSpecification)interactionFragment).getMessage();
                        DestroyElementRequest destroyRequest = new DestroyElementRequest(editingDomain, (EObject)message, false);
                        compositeCommand.add((IUndoableOperation)new DestroyElementCommand(destroyRequest));
                        continue;
                    }
                    DestroyElementRequest destroyRequest = new DestroyElementRequest(editingDomain, (EObject)interactionFragment, false);
                    compositeCommand.add((IUndoableOperation)new DestroyElementCommand(destroyRequest));
                }
            }
        }
    }

    protected List<InteractionFragment> findIntermediates(List<InteractionFragment> fragments, OccurrenceSpecification finish, Lifeline coveredLifeline, boolean found) {
        ArrayList<InteractionFragment> result = new ArrayList<InteractionFragment>();
        for (InteractionFragment interactionFragment : fragments) {
            if (found) {
                return result;
            }
            if (interactionFragment.equals(finish)) {
                found = true;
                continue;
            }
            if (interactionFragment instanceof OccurrenceSpecification) {
                if (!((OccurrenceSpecification)interactionFragment).getCovered().equals(coveredLifeline)) continue;
                result.add(interactionFragment);
                continue;
            }
            if (interactionFragment instanceof InteractionOperand) {
                result.addAll(this.findIntermediates((List<InteractionFragment>)((InteractionOperand)interactionFragment).getFragments(), finish, coveredLifeline, found));
                continue;
            }
            if (!(interactionFragment instanceof Interaction)) continue;
            result.addAll(this.findIntermediates((List<InteractionFragment>)((Interaction)interactionFragment).getFragments(), finish, coveredLifeline, found));
        }
        return result;
    }
}

