/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class MultiLabelDecorator
extends LabelProvider
implements ILabelDecorator,
IFontDecorator,
IColorDecorator {
    private ILabelDecorator[] decorators;

    public MultiLabelDecorator(ILabelDecorator[] decorators) {
        this.decorators = decorators;
    }

    public Image decorateImage(Image image, Object element) {
        int i = 0;
        while (i < this.decorators.length) {
            ILabelDecorator decorator = this.decorators[i];
            Image newImage = decorator.decorateImage(image, element);
            if (newImage != null) {
                image = newImage;
            }
            ++i;
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        int i = 0;
        while (i < this.decorators.length) {
            ILabelDecorator decorator = this.decorators[i];
            String newText = decorator.decorateText(text, element);
            if (newText != null) {
                text = newText;
            }
            ++i;
        }
        return text;
    }

    public void dispose() {
        int i = 0;
        while (i < this.decorators.length) {
            ILabelDecorator d = this.decorators[i];
            d.dispose();
            ++i;
        }
    }

    public Font decorateFont(Object element) {
        int i = 0;
        while (i < this.decorators.length) {
            ILabelDecorator decorator = this.decorators[i];
            if (decorator instanceof IFontDecorator) {
                return ((IFontDecorator)decorator).decorateFont(element);
            }
            ++i;
        }
        return null;
    }

    public Color decorateForeground(Object element) {
        int i = 0;
        while (i < this.decorators.length) {
            ILabelDecorator decorator = this.decorators[i];
            if (decorator instanceof IColorDecorator) {
                return ((IColorDecorator)decorator).decorateForeground(element);
            }
            ++i;
        }
        return null;
    }

    public Color decorateBackground(Object element) {
        int i = 0;
        while (i < this.decorators.length) {
            ILabelDecorator decorator = this.decorators[i];
            if (decorator instanceof IColorDecorator) {
                return ((IColorDecorator)decorator).decorateBackground(element);
            }
            ++i;
        }
        return null;
    }
}

