/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.validation.rules.blocks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.sysml14.blocks.Block;
import org.eclipse.papyrus.sysml14.blocks.ClassifierBehaviorProperty;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 *8.3.2.5 ClassifierBehaviorProperty
 *[1] ClassifierBehaviorProperty may only be applied to properties owned (not inherited) by blocks that have classifier behaviors.
 */
public class ClassifierBehaviorPropertyOnBlockModelConstraint extends AbstractModelConstraint {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.
	 * emf.validation.IValidationContext)
	 */
	@Override
	public IStatus validate(IValidationContext context) {
		ClassifierBehaviorProperty classifierBehaviorProperty = (ClassifierBehaviorProperty) context.getTarget();
		Property property = classifierBehaviorProperty.getBase_Property();
		if (property != null) {
			Element owner = property.getOwner();
			if (owner instanceof org.eclipse.uml2.uml.Class) {
				org.eclipse.uml2.uml.Class clazz = (org.eclipse.uml2.uml.Class) owner;
				if (UMLUtil.getStereotypeApplication(clazz, Block.class) == null
						|| clazz.getClassifierBehavior() == null ) {
					return context.createFailureStatus(context.getTarget());
				}		
			}
		}
		return context.createSuccessStatus();
	}

}
