/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.runtime;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.runtime.DefaultConstraintEngine;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.runtime.IConfigurationManager;
import org.eclipse.papyrus.infra.properties.ui.runtime.ViewConstraintEngine;

public class ViewConstraintEngineImpl
extends DefaultConstraintEngine<View>
implements ViewConstraintEngine {
    private final IConfigurationManager configManager;

    public ViewConstraintEngineImpl(IConfigurationManager configManager) {
        super(View.class);
        this.configManager = configManager;
    }

    public synchronized void refresh() {
        this.constraints.clear();
        Collection<Context> contexts = this.configManager.getEnabledContexts();
        for (Context context : contexts) {
            this.addContext(context);
        }
        this.fireConstraintsChanged();
    }

    @Override
    public void addContext(Context context) {
        for (View view : context.getViews()) {
            for (ConstraintDescriptor descriptor : view.getConstraints()) {
                this.addConstraint(descriptor);
            }
        }
    }

    @Override
    public Set<View> getViews(ISelection forSelection) {
        return this.getDisplayUnits(forSelection);
    }
}

