/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.hyperlink.commands.CreateHyperLinkDocumentCommand;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkDocument;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperlinkDocumentShell;
import org.eclipse.swt.widgets.Shell;

public class DocumentHyperLinkHelper
extends AbstractHyperLinkHelper {
    @Override
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        if (eAnnotation.getSource().equals("PapyrusHyperLink_Document")) {
            HyperLinkDocument hyperLinkDocument = new HyperLinkDocument();
            hyperLinkDocument.setHyperlinkDocument((String)eAnnotation.getDetails().get((Object)"localization"));
            hyperLinkDocument.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
            if (eAnnotation.getDetails().get((Object)"is_default_navigation") != null) {
                boolean isDefaultNaviagation = Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation"));
                hyperLinkDocument.setIsDefault(isDefaultNaviagation);
            } else {
                hyperLinkDocument.setIsDefault(false);
            }
            return hyperLinkDocument;
        }
        return null;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject hyperlinkObject) {
        if (hyperlinkObject instanceof HyperLinkDocument) {
            HyperLinkDocument hyperLinkDocument = (HyperLinkDocument)hyperlinkObject;
            return new CreateHyperLinkDocumentCommand(domain, object, hyperLinkDocument.getTooltipText(), hyperLinkDocument.getHyperlinkDocument(), hyperlinkObject.getIsDefault());
        }
        return null;
    }

    @Override
    public String getNameofManagedHyperLink() {
        return Messages.DocumentHyperLinkHelper_Document;
    }

    @Override
    public void executeNewMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject aModel) {
        EditorHyperlinkDocumentShell editor = new EditorHyperlinkDocumentShell(parentShell);
        editor.open();
        if (editor.getHyperlinkDocument() != null) {
            list.add(editor.getHyperlinkDocument());
        }
    }

    @Override
    public List<HyperLinkObject> getFilteredObject(List<HyperLinkObject> hyperlinkObjects) {
        ArrayList<HyperLinkObject> result = new ArrayList<HyperLinkObject>();
        for (HyperLinkObject hyperlinkObject : hyperlinkObjects) {
            if (!(hyperlinkObject instanceof HyperLinkDocument)) continue;
            result.add(hyperlinkObject);
        }
        return result;
    }
}

