/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.plugin.ASResourceFactoryRegistryReader;
import org.eclipse.ocl.pivot.internal.plugin.StandardLibraryRegistryReader;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.osgi.framework.BundleContext;

public final class PivotPlugin
extends EMFPlugin {
    public static final @NonNull String PLUGIN_ID = "org.eclipse.ocl.pivot";
    public static final @NonNull String AS_RESOURCE_FACTORY_PPID = "as_resource_factory";
    public static final @NonNull String LABEL_GENERATOR_PPID = "label_generator";
    public static final @NonNull String STANDARD_LIBRARY_PPID = "standard_library";
    public static final @NonNull String COMPLETE_OCL_REGISTRY_PID = "complete_ocl_registry";
    public static final @NonNull String COMPLETE_OCL_REGISTRY_QPID = "org.eclipse.ocl.pivot.complete_ocl_registry";
    public static final PivotPlugin INSTANCE = new PivotPlugin();
    private static Implementation plugin;

    public PivotPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void logError(String string, Throwable e) {
        if (plugin != null) {
            plugin.logError(string, e);
        } else {
            System.err.println(string);
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void logError(String string, Throwable e) {
            this.logException(this.newError(string, e));
        }

        public void logException(Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            IStatus status = null;
            if (e instanceof CoreException) {
                status = ((CoreException)e).getStatus();
            } else {
                String message = e.getMessage();
                if (message == null) {
                    message = e.toString();
                }
                status = new Status(4, PivotPlugin.PLUGIN_ID, 0, message, e);
            }
            this.log(status);
        }

        public CoreException newError(String text, Throwable exception) {
            return new CoreException((IStatus)new Status(4, PivotPlugin.PLUGIN_ID, 4, "ERROR -- " + text, exception));
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            new ASResourceFactoryRegistryReader().readRegistry();
            new StandardLibraryRegistryReader().readRegistry();
            PivotStandaloneSetup.doSetup();
        }
    }
}

