/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.IPageBookViewPageListener;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPropertySheetPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.papyrus.views.modelexplorer.SharedModelExplorerState;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.MultiViewPageBookView;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ViewPartPage;
import org.eclipse.papyrus.views.modelexplorer.sorting.DefaultTreeViewerSorting;
import org.eclipse.papyrus.views.modelexplorer.sorting.ITreeViewerSorting;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class ModelExplorerPageBookView
extends MultiViewPageBookView
implements IGotoMarker,
ITabbedPropertySheetPageContributor {
    public static final String VIEW_ID = "org.eclipse.papyrus.views.modelexplorer.modelexplorer";
    private final SharedModelExplorerState state = new SharedModelExplorerState();
    private List<IPropertySheetPage> propertiesSheetPages = new LinkedList<IPropertySheetPage>();
    private final CopyOnWriteArrayList<IPageBookViewPageListener> pageListeners = new CopyOnWriteArrayList();

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.state.load(memento);
        }
    }

    @Override
    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        ModelExplorerPage page = new ModelExplorerPage();
        page.setSharedState(this.state);
        this.initPage(page, part);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    private IPropertySheetPage getPropertySheetPage() {
        ModelExplorerPropertySheetPage propertySheetPage = new ModelExplorerPropertySheetPage(this);
        this.propertiesSheetPages.add((IPropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return this.getPropertySheetPage();
        }
        if (adapter == ITreeViewerSorting.class) {
            return new DefaultTreeViewerSorting(){

                @Override
                public void setSorted(boolean sorted) {
                    if (ModelExplorerPageBookView.this.state != null) {
                        ModelExplorerPageBookView.this.state.setAlphaSorted(sorted);
                    }
                }

                @Override
                public boolean isSorted() {
                    return ModelExplorerPageBookView.this.state != null && ModelExplorerPageBookView.this.state.isAlphaSorted();
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public void gotoMarker(IMarker marker) {
        String uriAttribute = marker.getAttribute("uri", null);
        if (uriAttribute != null) {
            ModelExplorerView modelExplorerView;
            EditingDomain domain;
            EObject eObject;
            URI uri = URI.createURI((String)uriAttribute);
            IViewPart viewPart = this.getActiveView();
            if (viewPart instanceof ModelExplorerView && (eObject = (domain = (modelExplorerView = (ModelExplorerView)viewPart).getEditingDomain()).getResourceSet().getEObject(uri, false)) != null) {
                CommonViewer treeViewer = ((ModelExplorerView)viewPart).getCommonViewer();
                ModelExplorerView.reveal(Lists.newArrayList((Object[])new EObject[]{eObject}), treeViewer);
            }
        }
    }

    public void saveState(IMemento memento) {
        this.state.save(memento);
        super.saveState(memento);
    }

    public void partClosed(IWorkbenchPart part) {
        PageBookView.PageRec rec = this.getPageRec(part);
        if (rec != null) {
            if (rec.page instanceof ModelExplorerPage) {
                ModelExplorerView explorer = (ModelExplorerView)((ModelExplorerPage)rec.page).getViewer();
                explorer.aboutToDispose();
            }
            if (rec.page instanceof ViewPartPage) {
                this.firePageClosing((ViewPartPage)rec.page);
            }
        }
        super.partClosed(part);
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        if (this.getSite().getPage().getActivePart() == this && pageRec != null && pageRec.page instanceof ViewPartPage) {
            this.firePageActivated((ViewPartPage)pageRec.page);
        }
    }

    public void setFocus() {
        try {
            super.setFocus();
        }
        catch (Exception ex) {
            Activator.log.warn("Error setting focus");
        }
        IPage page = this.getCurrentPage();
        if (page instanceof ViewPartPage) {
            this.firePageActivated((ViewPartPage)page);
        }
    }

    public void dispose() {
        for (IPropertySheetPage page : this.propertiesSheetPages) {
            page.dispose();
        }
        this.propertiesSheetPages.clear();
        super.dispose();
    }

    void addPageListener(IPageBookViewPageListener listener) {
        this.pageListeners.addIfAbsent(listener);
    }

    void removePageListener(IPageBookViewPageListener listener) {
        this.pageListeners.remove(listener);
    }

    private void firePageActivated(ViewPartPage page) {
        for (IPageBookViewPageListener next : this.pageListeners) {
            try {
                next.pageActivated(this, page);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in page activation listener.", (Throwable)e);
            }
        }
    }

    private void firePageClosing(ViewPartPage page) {
        for (IPageBookViewPageListener next : this.pageListeners) {
            try {
                next.pageClosing(this, page);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in page closing listener.", (Throwable)e);
            }
        }
    }
}

