/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.ICommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditingUtils {
    private EditingUtils() {
    }

    public static void moveElementsUp(EObject eObject, EStructuralFeature feature, Collection<Object> elements, ICommandFactory commandFactory, EditingDomain editingDomain) {
        CompoundCommand compoundCommand = new CompoundCommand();
        List list = (List)eObject.eGet(feature);
        int minIndex = 0;
        for (Object element : elements) {
            int index = list.indexOf(element);
            Command moveCommand = commandFactory.createMoveCommand(editingDomain, eObject, feature, element, Math.max(index - 1, minIndex++));
            compoundCommand.append(moveCommand);
        }
        editingDomain.getCommandStack().execute((Command)compoundCommand);
    }

    public static void moveElementsDown(EObject eObject, EStructuralFeature feature, Collection<Object> elements, ICommandFactory commandFactory, EditingDomain editingDomain) {
        Object value = eObject.eGet(feature);
        List list = (List)value;
        CompoundCommand compoundCommand = new CompoundCommand();
        boolean canMove = !elements.contains(list.get(list.size() - 1));
        int i = list.size() - 2;
        while (i >= 0) {
            Object selectedObject = list.get(i);
            if (elements.contains(selectedObject)) {
                if (canMove) {
                    Command moveCommand = commandFactory.createMoveCommand(editingDomain, eObject, feature, selectedObject, i + 1);
                    compoundCommand.append(moveCommand);
                }
            } else {
                canMove = true;
            }
            --i;
        }
        editingDomain.getCommandStack().execute((Command)compoundCommand);
    }
}

