/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryInfo {
    private String queryText;
    private boolean caseSensitive;
    private boolean regularExpression;
    private boolean searchAllStringAttributes;
    private Collection<? extends ParticipantTypeElement> participantTypes;
    private boolean searchForAllSter;
    private boolean searchForAnySter;
    private Collection<URI> scope;

    public QueryInfo(String queryText, boolean caseSensitive, boolean regularExpression, boolean searchAllStringAttributes, Collection<URI> scope) {
        this.queryText = queryText;
        this.caseSensitive = caseSensitive;
        this.regularExpression = regularExpression;
        this.searchAllStringAttributes = searchAllStringAttributes;
        this.participantTypes = Collections.emptyList();
        this.scope = scope;
    }

    public QueryInfo(String queryText, boolean caseSensitive, boolean regularExpression, Collection<? extends ParticipantTypeElement> participantTypes, Collection<URI> scope, boolean searchForAllSter, boolean searchForAnySter) {
        this.queryText = queryText;
        this.caseSensitive = caseSensitive;
        this.regularExpression = regularExpression;
        this.searchAllStringAttributes = false;
        this.participantTypes = participantTypes;
        this.scope = scope;
        this.searchForAllSter = searchForAllSter;
        this.searchForAnySter = searchForAnySter;
    }

    private QueryInfo(QueryInfo original, Collection<URI> scope) {
        this.queryText = original.queryText;
        this.caseSensitive = original.caseSensitive;
        this.regularExpression = original.regularExpression;
        this.searchAllStringAttributes = original.searchAllStringAttributes;
        this.participantTypes = original.participantTypes;
        this.searchForAllSter = original.searchForAllSter;
        this.searchForAnySter = original.searchForAnySter;
        this.scope = scope;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public boolean isSearchAllStringAttributes() {
        return this.searchAllStringAttributes;
    }

    public Collection<? extends ParticipantTypeElement> getParticipantTypes() {
        return this.participantTypes;
    }

    public Collection<URI> getScope() {
        return this.scope;
    }

    public boolean isSearchForAllSter() {
        return this.searchForAllSter;
    }

    public boolean isSearchForAnySter() {
        return this.searchForAnySter;
    }

    public QueryInfo partition(Collection<URI> scopePartition) {
        return new QueryInfo(this, scopePartition);
    }
}

