/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.utilities;

import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.impl.ContentHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;

public class NotXMLContentHandlerImpl
extends ContentHandlerImpl {
    protected @NonNull String @NonNull [] extensions;

    public NotXMLContentHandlerImpl(@NonNull String @NonNull [] extensions) {
        this.extensions = extensions;
    }

    public boolean canHandle(URI uri) {
        String fileExtension = uri.fileExtension();
        if (fileExtension != null) {
            String[] stringArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (fileExtension.equals(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Map<String, Object> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) {
        Map contentDescription = NotXMLContentHandlerImpl.createContentDescription((ContentHandler.Validity)ContentHandler.Validity.VALID);
        contentDescription.put("org.eclipse.emf.ecore:contentType", null);
        return contentDescription;
    }

    public static class Describer
    extends ContentHandlerImpl.Describer {
        protected ContentHandler createContentHandler(Map<String, String> parameters) {
            String rawExtensions = parameters.get("extensions");
            return new NotXMLContentHandlerImpl(rawExtensions != null ? rawExtensions.split(" ") : new String[]{});
        }

        public void setInitializationData(IConfigurationElement configurationElement, String propertyName, Object data) throws CoreException {
            String fileExtensions = configurationElement.getAttribute("file-extensions");
            this.contentHandler = new NotXMLContentHandlerImpl(fileExtensions != null ? fileExtensions.split(",") : new String[]{});
        }
    }
}

