/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.ui.IMemento;

class PaletteViewerReloadContextProvider
implements IReloadContextProvider {
    private static final String MEMENTO_ACTIVE_ENTRY = "activeEntry";
    private PaletteViewer palette;

    public PaletteViewerReloadContextProvider(PaletteViewer palette) {
        this.palette = palette;
    }

    public static IReloadContextProvider getInstance(PaletteViewer palette) {
        IReloadContextProvider result = (IReloadContextProvider)AdapterUtils.adapt((Object)palette, IReloadContextProvider.class, null);
        if (result == null) {
            result = new PaletteViewerReloadContextProvider(palette);
        }
        return result;
    }

    public Object createReloadContext() {
        IMemento result = UIUtil.createLocalMemento();
        this.palette.saveState(result);
        this.saveMoreState((PaletteEntry)this.palette.getPaletteRoot(), result);
        return result;
    }

    public void restore(Object reloadContext) {
        IMemento memento = (IMemento)reloadContext;
        this.palette.restoreState(memento);
        this.restoreMoreState((PaletteEntry)this.palette.getPaletteRoot(), memento);
    }

    void saveMoreState(PaletteEntry entry, IMemento memento) {
        if (entry instanceof PaletteStack) {
            PaletteStack stack = (PaletteStack)entry;
            memento.putInteger(MEMENTO_ACTIVE_ENTRY, stack.getChildren().indexOf(stack.getActiveEntry()));
        }
        if (entry instanceof PaletteContainer) {
            PaletteContainer container = (PaletteContainer)entry;
            List children = container.getChildren();
            IMemento[] mementos = memento.getChildren();
            int max = Math.min(children.size(), mementos.length);
            int i = 0;
            while (i < max) {
                this.saveMoreState((PaletteEntry)children.get(i), mementos[i]);
                ++i;
            }
        }
    }

    void restoreMoreState(PaletteEntry entry, IMemento memento) {
        List children;
        if (entry instanceof PaletteStack) {
            PaletteStack stack = (PaletteStack)entry;
            children = stack.getChildren();
            int activeIndex = memento.getInteger(MEMENTO_ACTIVE_ENTRY);
            if (activeIndex >= 0 && activeIndex < children.size()) {
                stack.setActiveEntry((PaletteEntry)children.get(activeIndex));
            }
        }
        if (entry instanceof PaletteContainer) {
            PaletteContainer container = (PaletteContainer)entry;
            children = container.getChildren();
            IMemento[] mementos = memento.getChildren();
            int max = Math.min(children.size(), mementos.length);
            int i = 0;
            while (i < max) {
                this.restoreMoreState((PaletteEntry)children.get(i), mementos[i]);
                ++i;
            }
        }
    }
}

