/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SelectAndDeleteCommand
extends PopupMenuCommand {
    private String choice;
    private CompositeCommand deleteAllCommand;
    private CompositeCommand keepCommand;
    private String[] labels;

    public SelectAndDeleteCommand(CompositeCommand deleteAllCommand, CompositeCommand keepCommand, String[] labels) {
        super("prompt for delete", Display.getCurrent().getActiveShell());
        PopupMenu popupMenu = new PopupMenu(Arrays.asList(labels), (ILabelProvider)new SelectLabelProvider());
        this.setPopupMenu(popupMenu);
        this.labels = labels;
        this.deleteAllCommand = deleteAllCommand;
        this.keepCommand = keepCommand;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        this.choice = cmdResult.getReturnValue().toString();
        if (this.choice.contains(this.labels[0])) {
            this.deleteAllCommand.execute(progressMonitor, info);
            return this.deleteAllCommand.getCommandResult();
        }
        this.keepCommand.execute(progressMonitor, info);
        return this.keepCommand.getCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.choice != null && this.choice.contains(this.labels[0])) {
            this.deleteAllCommand.undo(progressMonitor, info);
            return this.deleteAllCommand.getCommandResult();
        }
        this.keepCommand.undo(progressMonitor, info);
        return this.keepCommand.getCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.choice.contains(this.labels[0])) {
            this.deleteAllCommand.redo(progressMonitor, info);
            return this.deleteAllCommand.getCommandResult();
        }
        this.keepCommand.redo(progressMonitor, info);
        return this.keepCommand.getCommandResult();
    }

    public static class SelectLabelProvider
    extends LabelProvider {
        public String getText(Object object) {
            return object.toString();
        }

        public Image getImage(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE");
        }
    }
}

