/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.tree.objects;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ComboSelectionDialog;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class StereotypeValueTreeObject
extends ValueTreeObject {
    public StereotypeValueTreeObject(AppliedStereotypePropertyTreeObject parent, Object value) {
        super(parent, value);
        this.value = value;
    }

    @Override
    public void editMe() {
        String[] elementNames;
        EList values;
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.getParent();
        Element elt = ((StereotypedElementTreeObject)this.getParent().getParent().getParent()).getElement();
        Property property = pTO.getProperty();
        Type type = property.getType();
        ArrayList<Element> filteredElements = Util.getInstancesFilteredByType(elt, null, (Stereotype)type);
        if (property.isMultivalued() && (values = (EList)pTO.getValue()) != null) {
            Iterator<Element> filteredElementIt = filteredElements.iterator();
            while (filteredElementIt.hasNext()) {
                Element element;
                EObject stereoApplication;
                EObject eObj = (EObject)filteredElementIt.next();
                if (!(eObj instanceof Element) || !values.contains((Object)(stereoApplication = (element = (Element)eObj).getStereotypeApplication((Stereotype)type))) || stereoApplication == this.value) continue;
                filteredElementIt.remove();
            }
        }
        if ((elementNames = Util.getStringArrayFromList(filteredElements)) == null) {
            Message.warning("No element stereotyped <<" + type.getName() + ">> was found in the model.");
            return;
        }
        ProfileElementLabelProvider labelProvider = new ProfileElementLabelProvider();
        String initialValue = this.value != null ? labelProvider.getText(this) : elementNames[0];
        ComboSelectionDialog valueDialog = new ComboSelectionDialog(new Shell(), "New value:", elementNames, initialValue);
        int val = valueDialog.open();
        if (val == 0 && valueDialog.indexOfSelection != -1) {
            EList specialStereotypes;
            Element newElement = filteredElements.get(valueDialog.indexOfSelection);
            EObject newValue = newElement.getStereotypeApplication((Stereotype)type);
            if (newValue == null && !(specialStereotypes = newElement.getAppliedSubstereotypes((Stereotype)type)).isEmpty()) {
                newValue = newElement.getStereotypeApplication((Stereotype)specialStereotypes.get(0));
            }
            pTO.updateValue(pTO.appendMV(newValue));
        }
        valueDialog.close();
    }
}

