/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class ShowRowPositionsEvent
extends RowStructuralChangeEvent {
    public ShowRowPositionsEvent(ILayer layer, Collection<Integer> rowPositions) {
        super(layer, PositionUtil.getRanges(rowPositions));
    }

    protected ShowRowPositionsEvent(ShowRowPositionsEvent event) {
        super(event);
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        int offset = 0;
        for (Range range : this.getRowPositionRanges()) {
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, new Range(range.start - offset, range.start - offset), range));
            offset += range.size();
        }
        return rowDiffs;
    }

    @Override
    public ShowRowPositionsEvent cloneEvent() {
        return new ShowRowPositionsEvent(this);
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        super.convertToLocal(localLayer);
        return true;
    }
}

