/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.CreateRefactoringScriptWizard;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public final class CreateRefactoringScriptAction
implements IWorkbenchWindowActionDelegate {
    private static final int SIZING_WIZARD_HEIGHT = 610;
    private static final int SIZING_WIZARD_WIDTH = 500;
    private IWorkbenchWindow fWindow = null;

    private static void showCreateScriptWizard(IWorkbenchWindow window) {
        Assert.isNotNull((Object)window);
        final CreateRefactoringScriptWizard wizard = new CreateRefactoringScriptWizard();
        try {
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                    try {
                        service.connect();
                        wizard.setRefactoringHistory(service.getWorkspaceHistory(monitor));
                    }
                    finally {
                        service.disconnect();
                    }
                }
            });
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard){

            protected final void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                this.getButton(16).setText(ScriptingMessages.CreateRefactoringScriptAction_finish_button_label);
            }
        };
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 610);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.refactoring_create_script_page");
        dialog.open();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (this.fWindow != null) {
            CreateRefactoringScriptAction.showCreateScriptWizard(this.fWindow);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

