/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.participants;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

public class ChangeMethodSignatureArguments
extends RefactoringArguments {
    private String fNewName;
    private String fNewReturnType;
    private final int fNewVisibility;
    private final Parameter[] fNewParameters;
    private final ThrownException[] fThrownExceptions;
    private final boolean fKeepOriginal;

    public ChangeMethodSignatureArguments(String newName, String newReturnType, int newVisibility, Parameter[] newParameters, ThrownException[] thrownExceptions, boolean keepOriginal) {
        Assert.isNotNull((Object)newName);
        this.fNewName = newName;
        this.fNewReturnType = newReturnType;
        this.fNewVisibility = newVisibility;
        this.fNewParameters = newParameters;
        this.fThrownExceptions = thrownExceptions;
        this.fKeepOriginal = keepOriginal;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getNewReturnType() {
        return this.fNewReturnType;
    }

    public int getNewVisibility() {
        return this.fNewVisibility;
    }

    public Parameter[] getNewParameters() {
        return this.fNewParameters;
    }

    public ThrownException[] getThrownExceptions() {
        return this.fThrownExceptions;
    }

    public boolean getKeepOriginal() {
        return this.fKeepOriginal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("change signature to ");
        buf.append("\n\tvisibility: ").append(Flags.toString((int)this.fNewVisibility));
        buf.append("\n\treturn type sig: ").append(this.fNewReturnType);
        buf.append("\n\tnew name: ").append(this.fNewName);
        buf.append("\n\tkeep original: ").append(this.fKeepOriginal);
        int i = 0;
        while (i < this.fNewParameters.length) {
            buf.append("\n\tparameter ").append(i).append(": ").append(this.fNewParameters[i]);
            ++i;
        }
        i = 0;
        while (i < this.fThrownExceptions.length) {
            buf.append("\n\texception ").append(i).append(": ").append(this.fThrownExceptions[i]);
            ++i;
        }
        return buf.toString();
    }

    public static final class Parameter {
        private final int fOldIndex;
        private final String fNewName;
        private final String fNewSignature;
        private final String fDefaultValue;

        public Parameter(int oldIndex, String newName, String newSignature, String defaultValue) {
            this.fOldIndex = oldIndex;
            this.fNewName = newName;
            this.fNewSignature = newSignature;
            this.fDefaultValue = defaultValue;
        }

        public int getOldIndex() {
            return this.fOldIndex;
        }

        public String getName() {
            return this.fNewName;
        }

        public String getType() {
            return this.fNewSignature;
        }

        public String getDefaultValue() {
            return this.fDefaultValue;
        }

        public String toString() {
            return "name: " + this.fNewName + ", type: " + this.fNewSignature + ", oldIndex: " + this.fOldIndex + ", defaultValue: " + this.fDefaultValue;
        }
    }

    public static final class ThrownException {
        private final int fOldIndex;
        private final String fType;

        public ThrownException(int oldIndex, String newSignature) {
            this.fOldIndex = oldIndex;
            this.fType = newSignature;
        }

        public int getOldIndex() {
            return this.fOldIndex;
        }

        public String getType() {
            return this.fType;
        }

        public String toString() {
            return "type: " + this.fType + ", oldIndex: " + this.fOldIndex;
        }
    }
}

