/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class WorkspaceFileTargetHandle
extends AbstractTargetHandle {
    private IFile fFile;
    static final String SCHEME = "resource";
    public static HashMap<IFile, Object> mapFileTarget = new HashMap();

    static ITargetHandle restoreHandle(URI uri) {
        String part = uri.getSchemeSpecificPart();
        Path path = new Path(part);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return new WorkspaceFileTargetHandle(file);
    }

    public WorkspaceFileTargetHandle(IFile file) {
        this.fFile = file;
    }

    @Override
    public String getMemento() throws CoreException {
        try {
            URI uri = new URI(SCHEME, this.fFile.getFullPath().toPortableString(), null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.WorkspaceFileTargetHandle_0, (Throwable)e));
        }
    }

    @Override
    protected ITextFileBuffer getTextFileBuffer() throws CoreException {
        IStatus status;
        if (!this.fFile.exists()) {
            this.fFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        } else if (this.fFile.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.fFile}, null)).isOK()) {
            throw new CoreException(status);
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, null);
        return manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
    }

    @Override
    public boolean exists() {
        return this.fFile.exists();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceFileTargetHandle) {
            WorkspaceFileTargetHandle handle = (WorkspaceFileTargetHandle)obj;
            return this.fFile.equals((Object)handle.fFile);
        }
        return false;
    }

    public int hashCode() {
        return this.fFile.hashCode() + this.getClass().hashCode();
    }

    @Override
    void delete() throws CoreException {
        if (this.fFile.exists()) {
            this.fFile.delete(false, null);
        }
        P2TargetUtils.deleteProfile(this);
    }

    @Override
    public void save(ITargetDefinition definition) throws CoreException {
        ((TargetDefinition)definition).write(this.getTextFileBuffer());
        if (this.fFile.exists()) {
            this.fFile.refreshLocal(0, null);
        }
    }

    public String toString() {
        return this.fFile.getName();
    }

    public IFile getTargetFile() {
        return this.fFile;
    }

    public Object getWorkspaceEditor() {
        return mapFileTarget.get(this.fFile);
    }

    public void setWorkspaceEditor(Object target) {
        mapFileTarget.put(this.fFile, target);
    }
}

