/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.EscapeUtils;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetDialog;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.eclipse.help.ui.internal.views.ScopeState;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ScopeSelectPart
extends AbstractFormPart
implements IHelpPart {
    private FormText scopeSetLink;
    private Composite container;
    private String id;
    private ScopeObserver scopeObserver;

    public ScopeSelectPart(Composite parent, FormToolkit toolkit) {
        this.container = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        this.container.setLayout((Layout)layout);
        ScopeSetManager scopeSetManager = ScopeState.getInstance().getScopeSetManager();
        String name = scopeSetManager.getActiveSet().getName();
        this.scopeSetLink = toolkit.createFormText(this.container, false);
        this.setScopeLink(name);
        this.scopeSetLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ScopeSelectPart.this.doChangeScopeSet();
            }
        });
        toolkit.adapt((Control)this.scopeSetLink, true, true);
        TableWrapData td = new TableWrapData(256);
        td.valign = 32;
        this.scopeSetLink.setLayoutData((Object)td);
        this.scopeObserver = new ScopeObserver();
        scopeSetManager.addObserver(this.scopeObserver);
    }

    private void doChangeScopeSet() {
        ScopeSetManager scopeSetManager = ScopeState.getInstance().getScopeSetManager();
        ScopeSetDialog dialog = new ScopeSetDialog(this.container.getShell(), scopeSetManager, ScopeState.getInstance().getEngineManager(), true);
        dialog.setInput(scopeSetManager);
        dialog.create();
        dialog.getShell().setText(Messages.ScopeSetDialog_wtitle);
        if (dialog.open() == 0) {
            ScopeSet set = dialog.getActiveSet();
            if (set != null) {
                this.setActiveScopeSet(set);
            }
            scopeSetManager.save();
            scopeSetManager.notifyObservers();
        }
    }

    private void setActiveScopeSet(ScopeSet set) {
        this.setScopeLink(set.getName());
        ScopeState.getInstance().getScopeSetManager().setActiveSet(set);
        ScopeState.getInstance().getScopeSetManager().notifyObservers();
    }

    private void setScopeLink(String name) {
        StringBuilder buff = new StringBuilder();
        StringBuilder nameBuff = new StringBuilder();
        nameBuff.append("</b> <a href=\"rescope\" ");
        if (!Platform.getWS().equals("gtk")) {
            nameBuff.append(" alt=\"");
            nameBuff.append(Messages.FederatedSearchPart_changeScopeSet);
            nameBuff.append("\"");
        }
        nameBuff.append(">");
        nameBuff.append(EscapeUtils.escapeSpecialChars(name));
        nameBuff.append(" </a><b>");
        String scopeMessage = NLS.bind((String)Messages.ScopeSelect_scope, (Object)nameBuff.toString());
        buff.append("<form><p><b>");
        buff.append(scopeMessage);
        buff.append("</b></p></form>");
        this.scopeSetLink.setText(buff.toString(), true, false);
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.id = id;
        ScopeState.getInstance().setEngineManager(parent.getEngineManager());
    }

    @Override
    public void saveState(IMemento memento) {
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        this.container.setVisible(visible);
    }

    @Override
    public boolean hasFocusControl(Control control) {
        return false;
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    @Override
    public IAction getGlobalAction(String id) {
        return null;
    }

    @Override
    public void stop() {
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
    }

    public void dispose() {
        if (this.scopeObserver != null) {
            ScopeState.getInstance().getScopeSetManager().deleteObserver(this.scopeObserver);
        }
        super.dispose();
    }

    public class ScopeObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            String name = ScopeState.getInstance().getScopeSetManager().getActiveSet().getName();
            ScopeSelectPart.this.setScopeLink(name);
        }
    }
}

