/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.TextEditGroup;

public final class StubUtility2Core {
    public static ITypeBinding replaceWildcardsAndCaptures(ITypeBinding type) {
        while (type.isWildcardType() || type.isCapture() || type.isArray() && type.getElementType().isCapture()) {
            ITypeBinding bound = type.getBound();
            ITypeBinding iTypeBinding = type = bound != null ? bound : type.getErasure();
        }
        return type;
    }

    public static void addOverrideAnnotation(CodeGenerationSettings settings, IJavaProject project, ASTRewrite rewrite, ImportRewrite imports, MethodDeclaration methodDecl, boolean isDeclaringTypeInterface, TextEditGroup group) {
        if (!JavaModelUtil.is50OrHigher(project)) {
            return;
        }
        if (isDeclaringTypeInterface) {
            String version = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            if (JavaModelUtil.isVersionLessThan(version, "1.6")) {
                return;
            }
            if ("disabled".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", true))) {
                return;
            }
        }
        if (settings != null && settings.overrideAnnotation || !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", true))) {
            StubUtility2Core.createOverrideAnnotation(rewrite, imports, methodDecl, group);
        }
    }

    public static void createOverrideAnnotation(ASTRewrite rewrite, ImportRewrite imports, MethodDeclaration decl, TextEditGroup group) {
        if (StubUtility2Core.findAnnotation("java.lang.Override", decl.modifiers()) != null) {
            return;
        }
        AST ast = rewrite.getAST();
        ASTNode root = decl.getRoot();
        ContextSensitiveImportRewriteContext context = null;
        if (root instanceof CompilationUnit) {
            context = new ContextSensitiveImportRewriteContext((CompilationUnit)root, decl.getStartPosition(), imports);
        }
        MarkerAnnotation marker = ast.newMarkerAnnotation();
        marker.setTypeName(ast.newName(imports.addImport("java.lang.Override", (ImportRewrite.ImportRewriteContext)context)));
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, group);
    }

    public static boolean isCopyOnInheritAnnotation(ITypeBinding annotationType, IJavaProject project, EnumSet<ImportRewrite.TypeLocation> nullnessDefault, ImportRewrite.TypeLocation typeLocation) {
        if ("enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", true))) {
            return false;
        }
        if (nullnessDefault != null && Bindings.isNonNullAnnotation(annotationType, project)) {
            return !nullnessDefault.contains(typeLocation);
        }
        return Bindings.isAnyNullAnnotation(annotationType, project);
    }

    public static Annotation findAnnotation(String qualifiedTypeName, List<IExtendedModifier> modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Annotation annot;
            ITypeBinding binding;
            IExtendedModifier curr = modifiers.get(i);
            if (curr instanceof Annotation && (binding = (annot = (Annotation)curr).getTypeName().resolveTypeBinding()) != null && qualifiedTypeName.equals(binding.getQualifiedName())) {
                return annot;
            }
            ++i;
        }
        return null;
    }
}

