/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.notification;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.types.core.notification.TypesEventsChain;
import org.eclipse.papyrus.infra.types.core.notification.TypesListenersRegistry;
import org.eclipse.papyrus.infra.types.core.notification.events.AbstractTypesEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.AdviceApprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.AdviceDisapprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.AdvicePhase;
import org.eclipse.papyrus.infra.types.core.notification.events.AdviceRequestEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.EditHelperApprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.EditHelperDisapprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.EditHelperRequestEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.ExecutableAdviceEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.ExecutableEditHelperEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.IdentityAdviceEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.IdentityEditHelperEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.UnexecutableAdviceEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.UnexecutableEditHelperEvent;

public abstract class AbstractNotifierEditHelper
extends AbstractEditHelper {
    public ICommand getEditCommand(IEditCommandRequest req) {
        TypesEventsChain eventsChain = new TypesEventsChain((IEditHelper)this, req);
        IEditHelperAdvice[] advice = this.getEditHelperAdvice(req);
        this.configureRequest(req, advice, eventsChain);
        boolean approved = this.approveRequest(req, advice, eventsChain);
        if (!approved) {
            if (Platform.inDebugMode()) {
                TypesListenersRegistry.getInstance().notifyChain(eventsChain);
            }
            return null;
        }
        ICommand result = this.getEditCommand(req, advice, eventsChain);
        if (result != null) {
            if (Platform.inDebugMode()) {
                TypesListenersRegistry.getInstance().notifyChain(eventsChain);
            }
            return result.reduce();
        }
        if (Platform.inDebugMode()) {
            TypesListenersRegistry.getInstance().notifyChain(eventsChain);
        }
        return result;
    }

    private ICommand getEditCommand(IEditCommandRequest req, IEditHelperAdvice[] advice, TypesEventsChain eventsChain) {
        ICommand insteadCommand;
        Object replaceParam;
        ICompositeCommand command = this.createCommand(req);
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                ICommand beforeAdvice = nextAdvice.getBeforeEditCommand(req);
                if (beforeAdvice != null) {
                    AbstractTypesEvent event;
                    if (beforeAdvice.canExecute()) {
                        if (Platform.inDebugMode()) {
                            if (beforeAdvice.equals(IdentityCommand.INSTANCE)) {
                                event = new IdentityAdviceEvent(req, (IEditHelper)this, nextAdvice, advice, AdvicePhase.before);
                                eventsChain.addBeforeAdvicesCommandsEvent(event);
                                TypesListenersRegistry.getInstance().notifyEvent(event);
                            } else {
                                event = new ExecutableAdviceEvent(req, (IEditHelper)this, nextAdvice, beforeAdvice, advice, AdvicePhase.before);
                                eventsChain.addBeforeAdvicesCommandsEvent(event);
                                TypesListenersRegistry.getInstance().notifyEvent(event);
                            }
                        }
                        command.compose((IUndoableOperation)beforeAdvice);
                    } else {
                        if (Platform.inDebugMode()) {
                            event = new UnexecutableAdviceEvent(req, (IEditHelper)this, nextAdvice, beforeAdvice, advice, AdvicePhase.before);
                            eventsChain.addBeforeAdvicesCommandsEvent(event);
                            TypesListenersRegistry.getInstance().notifyEvent(event);
                        }
                        return beforeAdvice;
                    }
                }
                ++i;
            }
        }
        if ((replaceParam = req.getParameter("IEditCommandRequest.replaceDefaultCommand")) != Boolean.TRUE && (insteadCommand = this.getInsteadCommand(req)) != null) {
            AbstractTypesEvent event;
            if (insteadCommand.canExecute()) {
                if (Platform.inDebugMode()) {
                    if (insteadCommand.equals(IdentityCommand.INSTANCE)) {
                        event = new IdentityEditHelperEvent(req, (IEditHelper)this);
                        eventsChain.setEditHelperCommandEvent(event);
                        TypesListenersRegistry.getInstance().notifyEvent(event);
                    } else {
                        event = new ExecutableEditHelperEvent(req, (IEditHelper)this, insteadCommand);
                        eventsChain.setEditHelperCommandEvent(event);
                        TypesListenersRegistry.getInstance().notifyEvent(event);
                    }
                }
                command.compose((IUndoableOperation)insteadCommand);
            } else {
                if (Platform.inDebugMode()) {
                    event = new UnexecutableEditHelperEvent(req, (IEditHelper)this, insteadCommand);
                    eventsChain.setEditHelperCommandEvent(event);
                    TypesListenersRegistry.getInstance().notifyEvent(event);
                }
                return insteadCommand;
            }
        }
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                ICommand afterAdvice = nextAdvice.getAfterEditCommand(req);
                if (afterAdvice != null) {
                    AbstractTypesEvent event;
                    if (afterAdvice.canExecute()) {
                        if (Platform.inDebugMode()) {
                            if (afterAdvice.equals(IdentityCommand.INSTANCE)) {
                                event = new IdentityAdviceEvent(req, (IEditHelper)this, nextAdvice, advice, AdvicePhase.after);
                                eventsChain.addBeforeAdvicesCommandsEvent(event);
                                TypesListenersRegistry.getInstance().notifyEvent(event);
                            } else {
                                event = new ExecutableAdviceEvent(req, (IEditHelper)this, nextAdvice, afterAdvice, advice, AdvicePhase.after);
                                eventsChain.addBeforeAdvicesCommandsEvent(event);
                                TypesListenersRegistry.getInstance().notifyEvent(event);
                            }
                        }
                        command.compose((IUndoableOperation)afterAdvice);
                    } else {
                        if (Platform.inDebugMode()) {
                            event = new UnexecutableAdviceEvent(req, (IEditHelper)this, nextAdvice, afterAdvice, advice, AdvicePhase.after);
                            eventsChain.addBeforeAdvicesCommandsEvent(event);
                            TypesListenersRegistry.getInstance().notifyEvent(event);
                        }
                        return afterAdvice;
                    }
                }
                ++i;
            }
        }
        return command.isEmpty() ? null : command;
    }

    private void configureRequest(IEditCommandRequest req, IEditHelperAdvice[] advice, TypesEventsChain eventsChain) {
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                nextAdvice.configureRequest(req);
                if (Platform.inDebugMode()) {
                    AdviceRequestEvent event = new AdviceRequestEvent(req, (IEditHelper)this, nextAdvice, advice);
                    eventsChain.addAdviceRequestConfigurationEvent(event);
                    TypesListenersRegistry.getInstance().notifyEvent(event);
                }
                ++i;
            }
        }
        this.configureRequest(req);
        if (Platform.inDebugMode()) {
            EditHelperRequestEvent event = new EditHelperRequestEvent(req, (IEditHelper)this);
            eventsChain.setEditHelperRequestConfigurationEvent(event);
            TypesListenersRegistry.getInstance().notifyEvent(event);
        }
    }

    private boolean approveRequest(IEditCommandRequest req, IEditHelperAdvice[] advice, TypesEventsChain eventsChain) {
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                AbstractTypesEvent event;
                IEditHelperAdvice nextAdvice = advice[i];
                boolean approved = nextAdvice.approveRequest(req);
                if (!approved) {
                    if (Platform.inDebugMode()) {
                        event = new AdviceDisapprovedEvent(req, (IEditHelper)this, nextAdvice, advice);
                        eventsChain.addAdviceApprovalEvent(event);
                        TypesListenersRegistry.getInstance().notifyEvent(event);
                    }
                    return false;
                }
                if (Platform.inDebugMode()) {
                    event = new AdviceApprovedEvent(req, (IEditHelper)this, nextAdvice, advice);
                    eventsChain.addAdviceApprovalEvent(event);
                    TypesListenersRegistry.getInstance().notifyEvent(event);
                }
                ++i;
            }
        }
        boolean approved = this.approveRequest(req);
        if (Platform.inDebugMode()) {
            AbstractTypesEvent event;
            if (!approved) {
                event = new EditHelperDisapprovedEvent(req, (IEditHelper)this);
                eventsChain.setEditHelperApprovalEvent(event);
                TypesListenersRegistry.getInstance().notifyEvent(event);
            } else {
                event = new EditHelperApprovedEvent(req, (IEditHelper)this);
                eventsChain.setEditHelperApprovalEvent(event);
                TypesListenersRegistry.getInstance().notifyEvent(event);
            }
        }
        return approved;
    }
}

