/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.actions;

import java.util.Collections;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.views.validation.internal.Activator;
import org.eclipse.papyrus.views.validation.internal.actions.AbstractMarkerAction;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchSite;

public class GotoMarkerAction
extends AbstractMarkerAction {
    public GotoMarkerAction(IWorkbenchSite site) {
        super(site, "Go To");
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("goto_marker"));
    }

    public void run() {
        if (this.getMarker() != null) {
            this.gotoMarker();
        }
    }

    private void gotoMarker() {
        IRevealSemanticElement revealer = null;
        if (this.getMarker().getEObject() != null) {
            IViewReference[] iViewReferenceArray = this.getSite().getPage().getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference next = iViewReferenceArray[n2];
                IViewPart part = next.getView(false);
                if (part instanceof IRevealSemanticElement) {
                    revealer = (IRevealSemanticElement)part;
                    break;
                }
                if (part != null && (revealer = (IRevealSemanticElement)part.getAdapter(IRevealSemanticElement.class)) != null) break;
                ++n2;
            }
            if (revealer != null) {
                revealer.revealSemanticElement(Collections.singletonList(this.getMarker().getEObject()));
            }
        }
    }
}

