/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.OpenDiagramCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.navigation.CreatedNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.INavigationRule;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHelper {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.navigation.navigationRules";
    private static final String NAVIGATIONRULE_ID = "navigationRule";
    private static final String RULE_ID = "rule";
    private List<INavigationRule> navigationRules = new LinkedList<INavigationRule>();

    public static NavigationHelper getInstance() {
        return NavigationHelperHolder.instance;
    }

    private NavigationHelper() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (NAVIGATIONRULE_ID.equals(configElement.getName())) {
                try {
                    Object obj = configElement.createExecutableExtension(RULE_ID);
                    if (obj instanceof INavigationRule) {
                        this.navigationRules.add((INavigationRule)obj);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private void addNextNavigableElements(NavigableElement currentNavElement, List<NavigableElement> navElements) {
        navElements.add(currentNavElement);
        for (INavigationRule navigationRule : this.navigationRules) {
            if (!navigationRule.handle(currentNavElement.getElement())) continue;
            List<NavigableElement> nextNavigableElements = navigationRule.getNextPossibleElements(currentNavElement);
            for (NavigableElement nextNavigableElement : nextNavigableElements) {
                this.addNextNavigableElements(nextNavigableElement, navElements);
            }
        }
    }

    public List<NavigableElement> getAllNavigableElements(EObject element) {
        ArrayList<NavigableElement> navElements = new ArrayList<NavigableElement>();
        if (element != null) {
            this.addNextNavigableElements(new ExistingNavigableElement(element, null), navElements);
        }
        return navElements;
    }

    public static void linkToModel(CreatedNavigableElement createdNavElement) {
        NavigableElement navElement = createdNavElement;
        while (navElement instanceof CreatedNavigableElement) {
            CreatedNavigableElement cne = navElement;
            cne.linkToModel();
            navElement = cne.getPreviousNavigableElement();
        }
    }

    public static void setBaseName(CreatedNavigableElement createdNavElement, String base) {
        NavigableElement navElement = createdNavElement;
        while (navElement instanceof CreatedNavigableElement) {
            CreatedNavigableElement cne = navElement;
            cne.setBaseName(base);
            navElement = cne.getPreviousNavigableElement();
        }
    }

    public static CompositeCommand getLinkCreateAndOpenNavigableDiagramCommand(final NavigableElement navElement, ICreationCommand creationCommandInterface, String diagramName, ModelSet modelSet) {
        CompositeCommand compositeCommand = new CompositeCommand("Create diagram");
        if (navElement instanceof CreatedNavigableElement) {
            compositeCommand.add((IUndoableOperation)new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), "Create hierarchy", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    NavigationHelper.linkToModel((CreatedNavigableElement)navElement);
                    NavigationHelper.setBaseName((CreatedNavigableElement)navElement, "");
                    return CommandResult.newOKCommandResult();
                }
            });
        }
        ICommand createDiagCommand = creationCommandInterface.getCreateDiagramCommand(modelSet, navElement.getElement(), diagramName);
        compositeCommand.add((IUndoableOperation)createDiagCommand);
        compositeCommand.add((IUndoableOperation)new OpenDiagramCommand(modelSet.getTransactionalEditingDomain(), createDiagCommand));
        return compositeCommand;
    }

    /* synthetic */ NavigationHelper(NavigationHelper navigationHelper) {
        this();
    }

    private static class NavigationHelperHolder {
        public static final NavigationHelper instance = new NavigationHelper(null);

        private NavigationHelperHolder() {
        }
    }
}

