/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class RestoreDurationConstraintLinkCommand
extends AbstractTransactionalCommand {
    private IAdaptable dcViewAdapter;
    private EditPartViewer viewer;
    private Boolean isOnTop;
    private Point targetLocation;
    private PreferencesHint diagramPreferenceHint;

    public RestoreDurationConstraintLinkCommand(TransactionalEditingDomain domain, IAdaptable dcViewAdapter, EditPartViewer viewer, Boolean isOnTop, Point targetLocation, PreferencesHint diagramPreferenceHint) {
        super(domain, "Resotore Annotated Link", null);
        this.dcViewAdapter = dcViewAdapter;
        this.viewer = viewer;
        this.isOnTop = isOnTop;
        this.targetLocation = targetLocation;
        this.diagramPreferenceHint = diagramPreferenceHint;
    }

    public boolean canExecute() {
        if (this.dcViewAdapter == null || this.viewer == null || this.targetLocation == null) {
            return false;
        }
        return super.canExecute();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            return CommandResult.newCancelledCommandResult();
        }
        View view = (View)this.dcViewAdapter.getAdapter(View.class);
        if (view == null) {
            return CommandResult.newErrorCommandResult((String)"No view found");
        }
        EditPart sourceEditPart = (EditPart)this.viewer.getEditPartRegistry().get(view);
        if (sourceEditPart == null) {
            return CommandResult.newCancelledCommandResult();
        }
        Rectangle bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sourceEditPart);
        Point sourceLocation = null;
        sourceLocation = this.isOnTop != null ? (this.isOnTop != false ? bounds.getTop() : bounds.getBottom()) : (this.targetLocation.y >= bounds.getCenter().y ? bounds.getBottom() : bounds.getTop());
        EditPart targetEditPart = null;
        CreateConnectionViewRequest request = CreateViewRequestFactory.getCreateConnectionRequest((IElementType)UMLElementTypes.Comment_AnnotatedElementEdge, (PreferencesHint)this.diagramPreferenceHint);
        request.setLocation(sourceLocation);
        request.setType((Object)"annotated link start");
        request.setSourceEditPart(sourceEditPart);
        request.setTargetEditPart(sourceEditPart);
        Command command = sourceEditPart.getCommand((Request)request);
        request.setLocation(this.targetLocation);
        request.setType((Object)"annotated link end");
        targetEditPart = sourceEditPart.getViewer().findObjectAtExcluding(this.targetLocation, Collections.emptySet(), this.getTargetingConditional((Request)request));
        request.setTargetEditPart(targetEditPart);
        command = targetEditPart.getCommand((Request)request);
        if (command != null && command.canExecute()) {
            command.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    protected EditPartViewer.Conditional getTargetingConditional(final Request req) {
        return new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                return editpart.getTargetEditPart(req) != null;
            }
        };
    }
}

