/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.intempora.rtmaps.ui.handler;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.CombinedPopupAndViewBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.robotml.generators.intempora.rtmaps.Generate_rtmaps;

public class AcceleoRTMapsCodeGenerator {
    private EObject generationInputModel;
    private File rtmapsTargetFolder;

    public void runAcceleoTransformation(EObject generationInputModel, String rtmapsTargetFolderPath) {
        this.generationInputModel = generationInputModel;
        this.rtmapsTargetFolder = new File(rtmapsTargetFolderPath);
        if (this.generationInputModel != null && this.rtmapsTargetFolder != null) {
            try {
                File targetFolder = FileUtil.getWorkspaceFile((String)rtmapsTargetFolderPath);
                if (!targetFolder.getParentFile().exists()) {
                    targetFolder.getParentFile().mkdirs();
                }
                Generate_rtmaps generate = new Generate_rtmaps(this.generationInputModel, targetFolder, Collections.EMPTY_LIST);
                generate.doGenerate(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            new NotificationBuilder().setBuilderClass(CombinedPopupAndViewBuilder.class).setType(Type.ERROR).setTitle("Acceleo genration error").setMessage("You have to set the parameters of the generation").run();
        }
    }
}

