/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.wizards.wizards;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.robotics.wizards.Activator;
import org.eclipse.papyrus.robotics.wizards.pages.DummySelectRepresentationKindPage;
import org.eclipse.papyrus.robotics.wizards.pages.SelectViewPointPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRepresentationKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class NewRoboticsModelWizard
extends CreateModelWizard {
    private static final String DOT_UML = ".uml";
    private static final String DOT_DI = ".di";
    public static final String MODEL_NAME_UC = "[modelNameUC]";
    public static final String WIZARD_ID = "org.eclipse.papyrus.robotics.wizards.createmodel";
    protected SelectViewPointPage selectViewPointPage;
    protected DummySelectRepresentationKindPage selectRepresentationKindPage;

    public void addPage(IWizardPage page) {
        if (page instanceof SelectArchitectureContextPage) {
            this.selectViewPointPage = new SelectViewPointPage();
            super.addPage((IWizardPage)this.selectViewPointPage);
        } else if (!(page instanceof DummySelectRepresentationKindPage)) {
            super.addPage(page);
        }
    }

    protected String[] getSelectedContexts() {
        return new String[]{"org.eclipse.papyrus.robotics.architecture"};
    }

    protected String[] getSelectedViewpoints() {
        return this.selectViewPointPage.getSelectedIDs();
    }

    public void setViewpoint(String selectedId) {
        this.selectViewPointPage.setSelectedID(selectedId);
    }

    public void updateExtension() {
        String extension = this.getExtension();
        IWizardPage modelPage = this.getPages()[1];
        if (extension != null && modelPage instanceof NewModelFilePage) {
            ((NewModelFilePage)modelPage).diagramExtensionChanged(extension);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof SelectViewPointPage) {
            IWizardPage modelPage = this.getPages()[1];
            this.updateExtension();
            return modelPage;
        }
        return super.getNextPage(page);
    }

    protected String getExtension() {
        String extension = DOT_UML;
        String id = this.selectViewPointPage.getSelectedID();
        if (id != null && id.startsWith("org.eclipse.papyrus.robotics.viewpoint.")) {
            if (id.endsWith("ComponentDevelopment")) {
                extension = ".compdef.uml";
            } else if (id.endsWith("ServiceDesign")) {
                extension = ".servicedef.uml";
            } else if (id.endsWith("SystemConfiguration")) {
                extension = ".system.uml";
            } else if (id.endsWith("BehaviorDesign")) {
                extension = ".skills.uml";
            } else if (id.endsWith("BehaviorTreeDesign")) {
                extension = ".bt.uml";
            } else if (id.endsWith("TadkBasedHazardAnalysis")) {
                extension = ".thara.uml";
            }
        }
        return extension.replace(DOT_UML, DOT_DI).substring(1);
    }

    protected SelectRepresentationKindPage doCreateSelectRepresentationKindPage() {
        this.selectRepresentationKindPage = new DummySelectRepresentationKindPage(this.createContextProvider());
        return this.selectRepresentationKindPage;
    }

    public boolean performFinish() {
        this.selectRepresentationKindPage.selectTemplate(this.selectViewPointPage.getSelectedID());
        this.updateExtension();
        URI newURI = this.createNewModelURI("org.eclipse.papyrus.robotics.architecture");
        String[] viewpointIds = this.getSelectedViewpoints();
        this.createAndOpenPapyrusModel(newURI, "org.eclipse.papyrus.robotics.architecture", viewpointIds);
        return true;
    }

    protected String getRootElementName() {
        return String.valueOf(StringUtils.upperCaseFirst((String)this.selectRepresentationKindPage.getRootElementName())) + StringUtils.upperCaseFirst((String)this.getExtension().replace(DOT_DI, ""));
    }

    protected void initDomainModel(ModelSet modelSet, String contextId, String[] viewpointIds) {
        Package root;
        PackageableElement ne;
        super.initDomainModel(modelSet, contextId, viewpointIds);
        Resource umlR = UmlUtils.getUmlResource((ModelSet)modelSet);
        NotationModel notation = NotationUtils.getNotationModel((ModelSet)modelSet);
        try {
            final Diagram diagram = notation.getDiagram(MODEL_NAME_UC);
            if (diagram != null) {
                final String newName = String.valueOf(StringUtils.upperCaseFirst((String)this.selectRepresentationKindPage.getRootElementName())) + " diagram";
                this.getCommandStack(modelSet).execute((Command)new RecordingCommand(modelSet.getTransactionalEditingDomain()){

                    protected void doExecute() {
                        diagram.setName(newName);
                    }
                });
            }
        }
        catch (NotFoundException newName) {
        }
        catch (BadArgumentExcetion e) {
            Activator.log.error((Throwable)e);
        }
        if ((ne = (root = (Package)umlR.getContents().get(0)).getPackagedElement(MODEL_NAME_UC)) != null) {
            String ucFirst = StringUtils.upperCaseFirst((String)this.selectRepresentationKindPage.getRootElementName());
            SetRequest setRequest = new SetRequest((EObject)ne, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)ucFirst);
            ICommand setNameCmd = ElementEditServiceUtils.getCommandProvider((EObject)ne).getEditCommand((IEditCommandRequest)setRequest);
            if (setNameCmd.canExecute()) {
                this.getCommandStack(modelSet).execute(GMFtoEMFCommandWrapper.wrap((ICommand)setNameCmd));
            }
        }
    }
}

