/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.utils;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.PortInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.fromsys.MessageParser;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ReverseUtils;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;

public class ServiceDefUtils {
    public static Interface getServiceDef(Class component, PortInfo.PortKind portKind, String pkgName, String svcDefName) {
        String prefix = "";
        if (portKind == PortInfo.PortKind.PUBLISHER || portKind == PortInfo.PortKind.SUBSCRIBER) {
            prefix = "P_";
        } else if (portKind == PortInfo.PortKind.SERVER || portKind == PortInfo.PortKind.CLIENT) {
            prefix = "Q_";
        } else if (portKind == PortInfo.PortKind.ACTION_SRV || portKind == PortInfo.PortKind.ACTION_CLI) {
            prefix = "A_";
        }
        String qName = String.valueOf(pkgName) + "::" + "svcdefs" + "::" + prefix + svcDefName;
        NamedElement ne = ElementUtils.getQualifiedElementFromRS((Element)component, (String)qName);
        if (ne instanceof Interface) {
            return (Interface)ne;
        }
        qName = String.valueOf(pkgName) + "::" + "svcdefs" + "::" + svcDefName;
        ne = ElementUtils.getQualifiedElementFromRS((Element)component, (String)qName);
        if (ne instanceof Interface) {
            return (Interface)ne;
        }
        return null;
    }

    public static Interface getServiceDef(Class component, List<URI> pathMapURIs, PortInfo.PortKind portKind, MessageParser.MessageEntry entry) {
        return ServiceDefUtils.getServiceDef(component, pathMapURIs, portKind, entry.pkgName, entry.name);
    }

    public static Interface getServiceDef(Class component, List<URI> pathMapURIs, PortInfo.PortKind portKind, String pkgName, String svcDefName) {
        Interface sd = ServiceDefUtils.getServiceDef(component, portKind, pkgName, svcDefName);
        if (sd == null) {
            if (ElementUtils.getQualifiedElementFromRS((Element)component, (String)pkgName) == null) {
                String fileName = ReverseUtils.fileName(pkgName);
                for (URI pathURI : pathMapURIs) {
                    if (!pathURI.toString().endsWith(fileName)) continue;
                    component.eResource().getResourceSet().getResource(pathURI, true);
                    sd = ServiceDefUtils.getServiceDef(component, portKind, pkgName, svcDefName);
                    break;
                }
            }
            if (sd == null) {
                Activator.log.debug(String.format("Cannot find service definition for %s/%s.", pkgName, svcDefName));
                return null;
            }
        }
        return sd;
    }

    public static boolean isProvided(PortInfo.PortKind portKind) {
        return portKind == PortInfo.PortKind.PUBLISHER || portKind == PortInfo.PortKind.SERVER || portKind == PortInfo.PortKind.ACTION_SRV;
    }
}

