/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromsys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinitionModel;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.generics.Connects;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.ros2.base.ProcessUtils;
import org.eclipse.papyrus.robotics.ros2.base.Ros2ProcessBuilder;
import org.eclipse.papyrus.robotics.ros2.reverse.PortInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.fromsys.MessageParser;
import org.eclipse.papyrus.robotics.ros2.reverse.fromsys.NodeInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.CreatePortUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.FolderUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ModelTemplate;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ReverseUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ServiceDefUtils;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ReverseNodes {
    protected IProgressMonitor monitor;
    protected List<URI> pathMapURIs;
    protected List<NodeInfo> niList;
    protected Map<String, List<NodeInfo>> portHash;
    protected int response;
    protected static int DIALOG_NO = 0;
    protected static int DIALOG_YES = 1;
    protected static int DIALOG_NO_ALL = 2;
    protected static int DIALOG_YES_ALL = 3;

    public ReverseNodes(IProgressMonitor monitor) {
        this.monitor = monitor;
        for (Resource resource : ModelManagement.getResourceSet().getResources()) {
            resource.unload();
        }
        ModelManagement.getResourceSet().getResources().clear();
        this.pathMapURIs = ScanUtils.allPathmapModels((String)".servicedef.uml");
        this.niList = new ArrayList<NodeInfo>();
        this.portHash = new HashMap<String, List<NodeInfo>>();
        this.response = DIALOG_YES;
    }

    public void readNodeList() {
        Ros2ProcessBuilder pb = new Ros2ProcessBuilder(new String[]{"node", "list"});
        try {
            String line1;
            Process p = pb.start();
            BufferedReader results = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean error = ProcessUtils.logErrors((Process)p);
            if (error) {
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            while ((line1 = results.readLine()) != null) {
                String name;
                String[] frags = line1.split("/");
                if (frags.length < 2 || (name = frags[1].trim()).endsWith("_rclcpp_node") || name.endsWith("_client_node") || name.startsWith("transform_listener_") || name.startsWith("launch_ros_")) continue;
                lines.add(line1);
            }
            results.close();
            this.monitor.beginTask("reverse nodes", lines.size() + 1);
            for (String line : lines) {
                this.reverseNode(line);
                this.monitor.worked(1);
                if (this.monitor.isCanceled()) break;
            }
            this.createSystem();
        }
        catch (IOException | CoreException exp) {
            Activator.log.error(exp);
        }
    }

    public void reverseNode(String line) {
        String[] frags = line.split("/");
        try {
            IProject project;
            int top = frags.length == 3 ? 1 : 0;
            String pkgName = frags[top].trim();
            final String name = frags[top + 1].trim();
            this.monitor.subTask("reverse component " + name);
            String fileName = String.valueOf(name) + ".compdef.uml";
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (pkgName.length() == 0) {
                project = FolderUtils.obtainProject(fileName);
                pkgName = project != null ? project.getName() : name;
            }
            project = root.getProject(pkgName);
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            if (!project.exists()) {
                project.create((IProgressMonitor)progressMonitor);
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)progressMonitor);
            }
            final NodeInfo ni = new NodeInfo();
            ni.name = name;
            IFolder fModels = FolderUtils.createFolderStructure(project);
            IFolder fComponents = FolderUtils.getComponentFolder(fModels);
            IFile fCompModel = fComponents.getFile(fileName);
            URI newURI = URI.createURI((String)("platform:/resource/" + pkgName + "/models/components/" + fileName));
            if (fCompModel.exists() && (this.response == DIALOG_NO || this.response == DIALOG_YES)) {
                Display.getDefault().syncExec((Runnable)new UIQuestion(fCompModel.toString()));
            }
            if (!fCompModel.exists() || this.response == DIALOG_YES || this.response == DIALOG_YES_ALL) {
                ModelTemplate mt = new ModelTemplate(newURI, "compdef");
                final NotationModel notation = mt.getNotationModel();
                final Package pkg = mt.getUMLModel();
                PackageUtil.loadPackage((URI)URI.createURI((String)"pathmap://ROS2_LIBRARY/ros2.primitive.uml"), (ResourceSet)pkg.eResource().getResourceSet());
                PackageUtil.loadPackage((URI)CppUriConstants.ANSIC_LIB_URI, (ResourceSet)pkg.eResource().getResourceSet());
                final String lineFinal = line;
                RecordingCommand reverseComponent = new RecordingCommand(mt.getDomain()){

                    protected void doExecute() {
                        Class clazz;
                        ComponentDefinitionModel cd = (ComponentDefinitionModel)StereotypeUtil.applyApp((Element)pkg, ComponentDefinitionModel.class);
                        cd.setExternal(true);
                        pkg.setName(name);
                        ReverseUtils.setXmlID((NamedElement)pkg);
                        ni.type = clazz = (Class)pkg.getOwnedType("[modelNameUC]");
                        clazz.setName(name);
                        ReverseUtils.setXmlID((NamedElement)clazz);
                        ReverseNodes.this.reversePorts(clazz, ni, lineFinal, false);
                        ReverseNodes.this.reverseParams(clazz, lineFinal);
                        try {
                            Diagram diagram = notation.getDiagram("[modelNameUC]");
                            String newName = String.valueOf(StringUtils.upperCaseFirst((String)name)) + " diagram";
                            diagram.setName(newName);
                        }
                        catch (BadArgumentExcetion | NotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                };
                mt.executeCmd((Command)reverseComponent);
                mt.save((IProgressMonitor)progressMonitor);
                mt.dispose();
            } else {
                Resource r = ModelManagement.getResourceSet().getResource(newURI, true);
                Package rootPkg = (Package)r.getContents().get(0);
                NamedElement ne = rootPkg.getOwnedMember(null, false, UMLPackage.eINSTANCE.getClass_());
                if (ne instanceof Class) {
                    ni.type = (Class)ne;
                } else {
                    Activator.log.debug("not found");
                }
                this.reversePorts(ni.type, ni, line, true);
            }
            this.niList.add(ni);
        }
        catch (CoreException | ServiceException e) {
            e.printStackTrace();
        }
    }

    public void createSystem() throws CoreException {
        String fileName = "fromRos.uml";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile systemModel = root.getFile((IPath)new Path("/reverse/models/system/" + fileName));
        if (systemModel.exists()) {
            if (this.response == DIALOG_NO || this.response == DIALOG_YES) {
                Display.getDefault().syncExec((Runnable)new UIQuestion(systemModel.toString()));
            }
            if (this.response != DIALOG_YES && this.response != DIALOG_YES_ALL) {
                return;
            }
        }
        String pkgName = "reverse";
        IProject project = root.getProject(pkgName);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.create((IProgressMonitor)progressMonitor);
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)progressMonitor);
        }
        FolderUtils.createFolderStructure(project);
        URI newURI = URI.createURI((String)("platform:/resource/reverse/models/system/" + fileName));
        try {
            final ModelTemplate mt = new ModelTemplate(newURI, "system");
            RecordingCommand rc = new RecordingCommand(mt.getDomain()){

                protected void doExecute() {
                    Package root = mt.getUMLModel();
                    try {
                        Diagram diagram = mt.getNotationModel().getDiagram("[modelNameUC]");
                        diagram.setName("System diagram");
                    }
                    catch (BadArgumentExcetion | NotFoundException e) {
                        Activator.log.error(e);
                    }
                    Class system = (Class)root.getOwnedMember("System");
                    ReverseUtils.setXmlID((NamedElement)system);
                    for (NodeInfo ni : ReverseNodes.this.niList) {
                        if (system.getMember(ni.name) != null) continue;
                        Property instance = system.createOwnedAttribute(ni.name, (Type)ni.type);
                        ReverseUtils.setXmlID((NamedElement)instance);
                        ComponentInstance ci = (ComponentInstance)StereotypeUtil.applyApp((Element)instance, ComponentInstance.class);
                        ReverseUtils.setXmlID((EObject)ci, "ID_ST_" + ni.name);
                    }
                    for (String portName : ReverseNodes.this.portHash.keySet()) {
                        Connector c = system.createOwnedConnector(null);
                        StereotypeUtil.applyApp((Element)c, Connects.class);
                        String cname = "";
                        for (NodeInfo ni : ReverseNodes.this.portHash.get(portName)) {
                            if (ni.name.equals("rviz") || ni.name.equals("gazebo")) continue;
                            ConnectorEnd end = c.createEnd();
                            end.setPartWithPort(system.getAttribute(ni.name, null));
                            if (ni.type != null) {
                                end.setRole((ConnectableElement)ni.type.getOwnedPort(portName, null));
                            }
                            cname = String.valueOf(cname) + "_" + ni.name;
                        }
                        ReverseUtils.setXmlID((EObject)c, "ID_C" + cname);
                        if (c.getEnds().size() >= 2) continue;
                        c.destroy();
                    }
                }
            };
            mt.executeCmd((Command)rc);
            mt.save(this.monitor);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void reversePorts(Class component, NodeInfo ni, String qName, boolean readOnly) {
        Ros2ProcessBuilder pb = new Ros2ProcessBuilder(new String[]{"node", "info", qName});
        try {
            String line;
            Process p = pb.start();
            BufferedReader results = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean error = ProcessUtils.logErrors((Process)p);
            if (error) {
                return;
            }
            PortInfo.PortKind currentPK = PortInfo.PortKind.PUBLISHER;
            while ((line = results.readLine()) != null) {
                if ((line = MessageParser.filterComment(line)).contains("Publishers:")) {
                    currentPK = PortInfo.PortKind.PUBLISHER;
                    continue;
                }
                if (line.contains("Subscribers:")) {
                    currentPK = PortInfo.PortKind.SUBSCRIBER;
                    continue;
                }
                if (line.contains("Service Servers:")) {
                    currentPK = PortInfo.PortKind.SERVER;
                    continue;
                }
                if (line.contains("Service Clients:")) {
                    currentPK = PortInfo.PortKind.CLIENT;
                    continue;
                }
                if (line.contains("Action Servers:")) {
                    currentPK = PortInfo.PortKind.ACTION_SRV;
                    continue;
                }
                if (line.contains("Action Clients:")) {
                    currentPK = PortInfo.PortKind.ACTION_CLI;
                    continue;
                }
                String[] frags = line.split(":");
                if (frags.length != 2) continue;
                String qPortName = frags[0].trim();
                String qMessageName = frags[1].trim();
                MessageParser.MessageEntry entry = MessageParser.extractMessageEntry(qMessageName);
                if (entry.pkgName.equals("rcl_interfaces") || entry.pkgName.equals("lifecycle_msgs") || entry.pkgName.equals("rosgraph_msgs")) continue;
                String portName = qPortName.trim().substring(1);
                List<NodeInfo> niWithName = this.portHash.get(portName);
                if (niWithName == null) {
                    niWithName = new ArrayList<NodeInfo>();
                }
                niWithName.add(ni);
                this.portHash.put(portName, niWithName);
                Interface sd = ServiceDefUtils.getServiceDef(component, this.pathMapURIs, currentPK, entry);
                if (sd == null) break;
                PortInfo pi = new PortInfo();
                ni.ports.add(pi);
                pi.dtQName = portName;
                pi.pk = currentPK;
                pi.topic = portName;
                if (readOnly) continue;
                CreatePortUtils.createPort(component, pi, sd);
            }
            results.close();
        }
        catch (IOException exp) {
            Activator.log.error((Throwable)exp);
        }
    }

    public void reverseParams(Class component, String qName) {
        Ros2ProcessBuilder pb = new Ros2ProcessBuilder(new String[]{"param", "list", qName});
        try {
            String line;
            Process p = pb.start();
            BufferedReader results = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean error = ProcessUtils.logErrors((Process)p);
            if (error) {
                return;
            }
            Ros2ProcessBuilder pbDesc = new Ros2ProcessBuilder(new String[]{"param", "describe", qName});
            while (results.ready() && (line = results.readLine()) != null) {
                String param = line.trim();
                pbDesc.command().add(param);
            }
            results.close();
            String paramName = "";
            Class paramSet = ParameterUtils.getParameterClass((Class)component);
            Process pDesc = pbDesc.start();
            results = new BufferedReader(new InputStreamReader(pDesc.getInputStream()));
            error = ProcessUtils.logErrors((Process)pDesc);
            while (results.ready() && (line = results.readLine()) != null) {
                String name;
                NamedElement ne;
                String desc = line.trim();
                if (desc.startsWith("Parameter name:")) {
                    paramName = desc.substring("Parameter name:".length()).trim();
                }
                if (!desc.startsWith("Type:")) continue;
                String type = desc.substring(5).trim();
                int upper = 1;
                if (type.equals("string array")) {
                    type = "string";
                    upper = -1;
                }
                if ((ne = ElementUtils.getQualifiedElementFromRS((Element)component, (String)(name = "primitive::" + type))) == null) {
                    if (type.equals("boolean")) {
                        type = "bool";
                    }
                    if (type.equals("integer")) {
                        type = "int";
                    }
                    name = "AnsiCLibrary::" + type;
                    ne = ElementUtils.getQualifiedElementFromRS((Element)component, (String)name);
                }
                Property paramUML = paramSet.createOwnedAttribute(paramName, (Type)ne);
                StereotypeUtil.apply((Element)paramUML, ParameterEntry.class);
                if (upper != 1) {
                    paramUML.setUpper(upper);
                }
                if (ne != null) continue;
                Activator.log.debug(String.format("Cannot find type %s", type));
            }
            results.close();
        }
        catch (IOException exp) {
            Activator.log.error((Throwable)exp);
        }
    }

    protected class UIQuestion
    implements Runnable {
        protected String fileName;

        UIQuestion(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void run() {
            ReverseNodes.this.response = MessageDialog.open((int)3, (Shell)Display.getDefault().getActiveShell(), (String)"Overwrite model?", (String)String.format("A model for the node exists already (at the default location \"%s\"). Should it (and eventually subsequent existing ones) be overwritten?", this.fileName), (int)-1, (String[])new String[]{"no", "yes", "no to all", "yes to all"});
        }
    }
}

