/*******************************************************************************
 * Copyright (c) 2019 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.robotics.ros2.preferences;

public class Ros2PreferenceConstants {

	/**
	 * used ROS 2 distribution
	 */
	public static final String P_ROS_DISTRO = "rosDistro"; //$NON-NLS-1$

	/**
	 * list of paths in which to charge setup.bash files
	 */
	public static final String P_SETUP_PATH = "rosSetupPath"; //$NON-NLS-1$

	/**
	 * colcon build options, e.g. --symlink-install
	 */
	public static final String P_COLCON_OPTIONS = "colcon-options"; //$NON-NLS-1$

	/**
	 * colcon option to build a particular package
	 */
	public static final String P_COLCON_PACKAGES = "colcon-packages"; //$NON-NLS-1$

	/**
	 * maintainer name and e-mail
	 */
	public static final String P_MAINTAINER_NAME = "maintainer-name"; //$NON-NLS-1$
	public static final String P_MAINTAINER_MAIL = "maintainer-mail"; //$NON-NLS-1$

	/**
	 * author name and e-mail
	 */
	public static final String P_AUTHOR_NAME = "author-name"; //$NON-NLS-1$
	public static final String P_AUTHOR_MAIL = "author-mail"; //$NON-NLS-1$
}
