/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.launch.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.papyrus.robotics.ros2.base.ProcessUtils;
import org.eclipse.papyrus.robotics.ros2.base.Ros2ProcessBuilder;
import org.eclipse.papyrus.robotics.ros2.launch.Activator;
import org.eclipse.papyrus.robotics.ros2.launch.lifecycle.StateInfo;

public class LifecycleState {
    public static long MAX_AGE = 1500L;
    protected String[] statesStr = new String[]{"unconfigured", "inactive", "active", "shutdown"};
    static Map<String, StateInfo> hash = new WeakHashMap<String, StateInfo>();

    public static EState getState(String nodename) {
        long time = System.currentTimeMillis();
        StateInfo si = hash.get(nodename);
        if (si != null) {
            if (time - si.time < MAX_AGE) {
                return si.state;
            }
        } else {
            si = new StateInfo();
            hash.put(nodename, si);
        }
        si.time = time;
        si.state = EState.UNKNOWN;
        Ros2ProcessBuilder pbLC = new Ros2ProcessBuilder(new String[]{"lifecycle", "get", nodename});
        try {
            Process p = pbLC.start();
            if (p.waitFor(2000L, TimeUnit.MILLISECONDS)) {
                BufferedReader results;
                String line;
                boolean error = ProcessUtils.logErrors((Process)p);
                if (!error && (line = (results = new BufferedReader(new InputStreamReader(p.getInputStream()))).readLine()) != null) {
                    si.state = LifecycleState.getEState(line);
                }
            } else {
                Activator.log.debug("failed to obtain state before timeout");
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        return si.state;
    }

    public static void setState(String nodename, EState state) {
        StateInfo si = hash.get(nodename);
        if (si == null) {
            si = new StateInfo();
            hash.put(nodename, si);
        }
        Ros2ProcessBuilder pbLC = new Ros2ProcessBuilder(new String[]{"lifecycle", "set", nodename, state.name().toLowerCase()});
        try {
            long time;
            Process p = pbLC.start();
            ProcessUtils.logErrors((Process)p);
            si.time = time = System.currentTimeMillis();
            si.state = state;
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static EState getEState(String stateStr) {
        try {
            String[] stateArray = stateStr.split(" ");
            return EState.valueOf(stateArray[0].toUpperCase().trim());
        }
        catch (IllegalArgumentException e) {
            return EState.UNKNOWN;
        }
    }

    public static enum EState {
        UNKNOWN,
        UNCONFIGURED,
        INACTIVE,
        ACTIVE,
        FINALIZED,
        CONFIGURE,
        ACTIVATE,
        DEACTIVATE,
        SHUTDOWN,
        CLEANUP;

    }
}

