/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.build;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.robotics.codegen.common.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.PackageXMLUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CreateCompPackageXML {
    public static String USER = "USER";

    public static CharSequence createPackageXML(Package model, List<Class> allComponents, List<Class> componentsInPkg, Class system) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<Package> entities = CreateCompPackageXML.entityArray(allComponents, system);
        _builder.newLineIfNotEmpty();
        _builder.append("<?xml version=\"1.0\"?>");
        _builder.newLine();
        _builder.append("<package format=\"3\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<name>");
        String _pkgName = PackageTools.pkgName((Package)model);
        _builder.append(_pkgName, "\t");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<version>0.0.0</version>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<description>");
        String _description = PackageXMLUtils.description(entities);
        _builder.append(_description, "\t");
        _builder.append("</description>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<maintainer email=\"");
        String _maintainerMail = PackageXMLUtils.getMaintainerMail(entities);
        _builder.append(_maintainerMail, "\t");
        _builder.append("\">");
        String _maintainerName = PackageXMLUtils.getMaintainerName(entities);
        _builder.append(_maintainerName, "\t");
        _builder.append("</maintainer>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<license>Apache2.0</license>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<url type=\"website\">https://eclipse.org/papyrus</url>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<author email=\"");
        String _authorMail = PackageXMLUtils.getAuthorMail(entities);
        _builder.append(_authorMail, "\t");
        _builder.append("\">");
        String _authorName = PackageXMLUtils.getAuthorName((Package)model);
        _builder.append(_authorName, "\t");
        _builder.append("</author>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<buildtool_depend>ament_cmake</buildtool_depend>");
        _builder.newLine();
        _builder.newLine();
        List<String> _calcDependencies = CreateCompPackageXML.calcDependencies(model, allComponents, componentsInPkg);
        for (String dependency : _calcDependencies) {
            _builder.append("\t");
            _builder.append("<build_depend>");
            _builder.append(dependency, "\t");
            _builder.append("</build_depend>");
            _builder.newLineIfNotEmpty();
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)SkillUtils.getUniqueSkills((Class)system));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("<build_depend>");
            String _realizationPackageName = SkillUtils.realizationPackageName((Package)model);
            _builder.append(_realizationPackageName, "\t");
            _builder.append("</build_depend>");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        List<String> _calcDependencies_1 = CreateCompPackageXML.calcDependencies(model, allComponents, componentsInPkg);
        for (String dependency_1 : _calcDependencies_1) {
            _builder.append("\t");
            _builder.append("<exec_depend>");
            _builder.append(dependency_1, "\t");
            _builder.append("</exec_depend>");
            _builder.newLineIfNotEmpty();
        }
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)SkillUtils.getUniqueSkills((Class)system));
        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            _builder.append("\t");
            _builder.append("<exec_depend>");
            String _realizationPackageName_1 = SkillUtils.realizationPackageName((Package)model);
            _builder.append(_realizationPackageName_1, "\t");
            _builder.append("</exec_depend>");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<export>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<build_type>ament_python</build_type>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</export>");
        _builder.newLine();
        _builder.append("</package>");
        _builder.newLine();
        return _builder;
    }

    public static List<String> calcDependencies(Package model, List<Class> allComponents, List<Class> componentsInPkg) {
        List dependencies = MessageUtils.calcDependencies(componentsInPkg);
        int i = 0;
        for (String dependency : dependencies) {
            int _plusPlus = i++;
            dependencies.set(_plusPlus, dependency.replaceFirst("rclcpp", "rclpy"));
        }
        for (Class component : allComponents) {
            String _pkgName_1;
            boolean _notEquals;
            List _dependsPackage = ComponentUtils.getDependsPackage((Class)component);
            for (String pkgName : _dependsPackage) {
                dependencies.add(pkgName);
            }
            String _pkgName = PackageTools.pkgName((Package)component.getModel());
            boolean bl = _notEquals = !Objects.equal((Object)_pkgName, (Object)(_pkgName_1 = PackageTools.pkgName((Package)model)));
            if (!_notEquals) continue;
            dependencies.add(PackageTools.pkgName((Package)component.getModel()));
        }
        return dependencies;
    }

    public static ArrayList<Package> entityArray(List<Class> components, Class system) {
        ArrayList<Package> entities = new ArrayList<Package>();
        if (system != null) {
            entities.add(PackageUtil.getRootPackage((Element)system));
        }
        for (Class component : components) {
            entities.add(PackageUtil.getRootPackage((Element)component));
        }
        return entities;
    }

    public static void generate(IPFileSystemAccess fileAccess, Package pkg, List<Class> allComponents, List<Class> componentsInPkg, Class system) {
        fileAccess.generateFile("package.xml", CreateCompPackageXML.createPackageXML(pkg, allComponents, componentsInPkg, system).toString());
    }
}

