/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.cdteditor.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor.SyncCDTEditor;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.handler.SyncCDTEditorHandler;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncCDTtoModel;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.CheckedOperationHistory;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.ros2.cdteditor.Activator;
import org.eclipse.papyrus.robotics.ros2.cdteditor.sync.SyncRoboticsCDTtoModel;
import org.eclipse.papyrus.robotics.ros2.cdteditor.sync.SyncRoboticsModelToCDT;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class SyncRoboticsCDTEditorHandler
extends SyncCDTEditorHandler {
    public static final String CDT_EDITOR_QNAME = "org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor.SyncCDTEditor";
    public static final String STANDARD_C = "Standard C++";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final ServicesRegistry serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
            AbstractEMFOperation command = new AbstractEMFOperation(domain, "Create CDT editor"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        SyncRoboticsCDTEditorHandler.this.doExecute(serviceRegistry);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    catch (NotFoundException e) {
                        Activator.log.error((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            CheckedOperationHistory.getInstance().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error("Can't create a CDT editor", (Throwable)e);
        }
        catch (ServiceException e) {
            Activator.log.error("Service exception during creation of CDT editor", (Throwable)e);
        }
        return null;
    }

    public void doExecute(final ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        final Classifier classifierToEdit = this.getClassifierToEdit();
        final IFile srcFile = SyncRoboticsModelToCDT.syncModelToCDT(classifierToEdit, STANDARD_C);
        if (srcFile == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    FileEditorInput input = new FileEditorInput(srcFile);
                    IEditorPart editorPart = page.openEditor((IEditorInput)input, SyncRoboticsCDTEditorHandler.CDT_EDITOR_QNAME);
                    if (editorPart instanceof SyncCDTEditor) {
                        String projectName = PackageTools.getProjectName((Package)classifierToEdit.getNearestPackage());
                        SyncRoboticsCDTtoModel syncCpp = new SyncRoboticsCDTtoModel((IEditorInput)input, classifierToEdit, projectName, SyncRoboticsCDTEditorHandler.STANDARD_C);
                        ((SyncCDTEditor)editorPart).setEditorData(serviceRegistry, (SyncCDTtoModel)syncCpp);
                    }
                }
                catch (PartInitException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        });
    }

    protected Classifier getClassifierToEdit() {
        Classifier cl = super.getClassifierToEdit();
        if (StereotypeUtil.isApplied((Element)cl, Activity.class)) {
            return (Classifier)cl.getOwner();
        }
        return cl;
    }
}

