/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.papyrus.robotics.ros2.base.Activator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ProcessUtils {
    public static final String ROS2_CON = "ROS 2";

    public static boolean logErrors(Process p) {
        return ProcessUtils.logProcess(p, LogKind.ERRORS);
    }

    public static boolean logProcess(Process p, LogKind kind) {
        boolean hasErrors = false;
        try {
            String msg;
            MessageConsole mc = ProcessUtils.findConsole(ROS2_CON);
            MessageConsoleStream conOut = mc.newMessageStream();
            if (kind == LogKind.ERRORS || kind == LogKind.ALL) {
                BufferedReader errors = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while (errors.ready() && (msg = errors.readLine()) != null) {
                    conOut.println(msg);
                    if (hasErrors) continue;
                    hasErrors = true;
                }
                errors.close();
            }
            if (kind == LogKind.OUTPUT || kind == LogKind.ALL) {
                BufferedReader outputs = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (outputs.ready() && (msg = outputs.readLine()) != null) {
                    conOut.println(msg);
                }
                outputs.close();
            }
            conOut.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return hasErrors;
    }

    public static void writeToConsole(String info) {
        MessageConsole mc = ProcessUtils.findConsole(ROS2_CON);
        MessageConsoleStream conOut = mc.newMessageStream();
        conOut.println(info);
        try {
            conOut.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole ros2Console = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{ros2Console});
        return ros2Console;
    }

    public static enum LogKind {
        ERRORS,
        OUTPUT,
        ALL;

    }
}

