/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.tables.contracts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Contract;
import org.eclipse.papyrus.uml.nattable.manager.axis.AbstractUMLSynchronizedOnFeatureAxisManager;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class ContractRowAxisManager
extends AbstractUMLSynchronizedOnFeatureAxisManager {
    protected Adapter adapter;

    protected abstract EReference getFeature();

    protected List<Object> getFeaturesValue() {
        Contract contract;
        EObject context = this.getTableContext();
        ArrayList<Object> featureValue = new ArrayList<Object>();
        if (context instanceof Comment && (contract = (Contract)UMLUtil.getStereotypeApplication((Element)((Comment)context), Contract.class)) != null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == ContractRowAxisManager.this.getFeature()) {
                        ContractRowAxisManager.this.featureValueHasChanged(notification);
                    }
                }
            };
            contract.eAdapters().add((Object)this.adapter);
            featureValue.addAll((List)contract.eGet((EStructuralFeature)this.getFeature()));
        }
        return featureValue;
    }

    protected void featureValueHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        if (notification.getEventType() == 6) {
            ArrayList toRemove = new ArrayList();
            Collection oldValues = (Collection)notification.getOldValue();
            for (Object current : oldValues) {
                if (!this.managedObject.contains(current)) continue;
                toRemove.add(current);
            }
            if (toRemove.size() > 0) {
                this.updateManagedList(Collections.emptyList(), toRemove);
            }
        } else {
            super.featureValueHasChanged(notification);
        }
    }

    protected void removeListeners() {
        super.removeListeners();
        EObject context = this.getTableContext();
        if (this.adapter != null && context instanceof Comment) {
            Contract contract = (Contract)UMLUtil.getStereotypeApplication((Element)((Comment)context), Contract.class);
            contract.eAdapters().remove((Object)this.adapter);
            this.adapter = null;
        }
    }

    protected Collection<EStructuralFeature> getListenFeatures() {
        Collection listenedFeatures = super.getListenFeatures();
        listenedFeatures.add(this.getFeature());
        return listenedFeatures;
    }
}

